#!/usr/bin/env node
// forth compiler
'use strict';

var fs = require('fs'),
    path = require('path'),
    cli = require('commander'),
    pkg = require('./package.json');

cli
    .version(pkg.version)
    .usage('[options] <file>')
    .parse(process.argv);

if (cli.args.length === 0) {
    cli.help();
}

fs.readFile(
    path.resolve(process.cwd(), cli.args[0]),
    {encoding: 'utf8'},
    function (err, txt) {
        var out = '';
        if (err) { return err; }
        txt.split('\n').forEach(function (str) {
            if (str.slice(0, 4) === '    ') {
                out += str.trim() + '\n';
            }
        });
        console.log(out.split(new RegExp('\\s+')));
    }
);
