#!/usr/bin/env node
'use strict';

var forth = require('../lib'),
    colors = require('colors/safe'),
    repl = require('repl');

console.log('forth v%s', forth.pkg.version);

repl.start({
    prompt: colors.green('\u25B6 '),
    input: process.stdin,
    output: process.stdout,
    eval: function (cmd, context, filename, callback) {
        var result = cmd.trim();
        forth[result]();
        callback(null, result);
    }
});

// create clean forth object

// connect stdin/stdout to the forth stream
// process.stdin.setEncoding('utf8');
// process.stdin.pipe(forth.inputStream);
// forth.outputStream.pipe(process.stdout);

forth.quit();
