// RTX2000 Instruction Set definition
'use strict';

module.exports = function () {
    var pc,
        top,
        next,
        borrow,
        carry,
        index,
        ds = [],
        rs = [];

    return {
        '0aaaaaaaaaaaaaaa': function __call (a) {
            rs.push(pc);
            pc = a;
        },
        '10000ppaaaaaaaaa': function __if (a) {
            if (top === 0) {
                ds.pop();
            }
            pc = a;
        },
        '10001ppaaaaaaaaa': function __iff (a) {
            if (top === 0) {
                ds.pop();
            }
            pc = a;
        },
        '10010ppaaaaaaaaa': function __branch (a) {
            rs.push(index);
            index = pc;
            pc = a;
        },
        '10011ppaaaaaaaaa': function __next (a, p) {
            index--;
            if (index === 0) {
                pc = a & ((p << 9) ^ pc);
            }
        },
        '1010aaaaikr0ssss': function __alu (s, r, k, i, a) {
            var temp, wuy;

            // ALU function select
            temp =
            (a === 0) ? top :
            // 1
            (a === 2) ? top & wuy :
            (a === 3) ? ~(top | wuy) :
            (a === 4) ? wuy - top :
            (a === 5) ? wuy - top - borrow :
            (a === 6) ? top | wuy :
            (a === 7) ? ~(top & wuy) :
            (a === 8) ? top + wuy :
            (a === 9) ? top + wuy + carry :
            (a === 10) ? top ^ wuy :
            (a === 11) ? ~(top ^ wuy) :
            (a === 12) ? top - wuy :
            (a === 13) ? top - wuy - borrow :
            // 14
            (a === 15) ? wuy :
            top;

            // Subroutine return
            if (r === 1) {
                pc = rs.pop();
            }

            // Shift control
            wuy =
            (s === 1) ? 0 :
            (s === 2) ? top << 1 :
            (s === 3) ? (top << 1) & carry :
            // TODO ...
            0;
        }
    };
};
