/**
* Copyright 2012-2018, Plotly, Inc.
* All rights reserved.
*
* This source code is licensed under the MIT license found in the
* LICENSE file in the root directory of this source tree.
*/

'use strict';


// IMPORTANT - default colors should be in hex for compatibility
exports.defaults = [
    '#2BC9E2',  // safety orange
    '#FAA654',  // cooked asparagus green
    '#5DCB7E',  // brick red
    '#FFE06E',  // muted purple
    '#0D94F6',  // chestnut brown
    '#42D99A',  // middle gray
    '#BDBF1D',  // curry yellow-green
    '#FF8500',   // blue-teal
    '#F77373',  // muted blue
    '#FFB2B0'  // raspberry yogurt pink
];

exports.defaultLine = '#444';

exports.lightLine = '#eee';

exports.background = '#fff';

exports.borderLine = '#BEC8D9';

// with axis.color and Color.interp we aren't using lightLine
// itself anymore, instead interpolating between axis.color
// and the background color using tinycolor.mix. lightFraction
// gives back exactly lightLine if the other colors are defaults.
exports.lightFraction = 100 * (0xe - 0x4) / (0xf - 0x4);
