
var path = require('path');

var showModelPrompt = function(self, done) {
  self.prompt([{
    type:'input',
    name:'model',
    message:'Enter the model you want to add (_User, Product, ...) or \"done\" if you are'
  }], function(props) {
    console.log(props);
    if ( props.model == 'done') {
      console.log('DONE');
      done();
    } else {
      self.models.push(props.model);
      console.log(self.models);
      addModelPrompt(self, done);
    }
  }.bind(self));  
}

module.exports = {
  ask: function(self) {
    var done = self.async();

    self.prompt([{
      type: 'confirm',
      name: 'models',
      message: 'Would you like to add some model now (_User, Product, ...) ?'
    }], function (props) {
      if (props.models == true) {
        self.models = [];        
        showModelPrompt(self, done);
      } else {
        done();
      }
    }.bind(self));
  },
  install: function(self) {
    var models = self.models;
    var done = self.async();
    for (var i = models.length - 1; i >= 0; i--) {
      var m = models[i];
      var modelFile = self.readFileAsString(path.join(__dirname, '../templates/scripts/model.js'))
      modelFile = modelFile.replace("{{APP_NAME}}", self.appName);
      modelFile = modelFile.replace("{{MODEL}}", m);
      self.write(path.join(self.appPath, m + '.js'), modelFile);
    };
    done();
  },


};
