
var path = require('path');

var showRouteAbstractPrompt = function(self, routeObj, done) {
  var route = {};
  self.prompt([{
    type:'confirm',
    name:'routeAbstract',
    message:'Is ' + routeObj.state + ' state abstract ?',
    default: false
  }], function(response) {
    routeObj.abstract = response.routeAbstract;
    self.routes.push(routeObj);
    console.log('Current routes: ' + self.routes);
    for (var i = self.routes.length - 1; i >= 0; i--) {
      var r = self.routes[i];
      console.log(' > state: ' + r.state + ' url:' + r.url + ' abstract:' + r.abstract);
    };
    showRouteStatePrompt(self, done);
  });
}
var showRouteUrlPrompt = function(self, routeObj, done) {
  self.prompt([{
    type:'input',
    name:'routeUrl',
    message:'Enter the route URL for ' + routeObj.state + ' or \"done\" if you are',
    default: routeObj.state
  }], function(response) {
      if ( response.routeState == 'done') {
        done();
    } else {
      routeObj.url = response.routeUrl;
      self.routes.push(routeObj);
      console.log('Current routes: ' + self.routes);
      showRouteAbstractPrompt(self, routeObj, showRouteStatePrompt, done);
    }
  });
}
var showRouteStatePrompt = function(self, done) {
  var routeObj = {};
  self.prompt([{
    type:'input',
    name:'routeState',
    message:'Enter the route state or \"done\" if you are'
  }], function(response) {
      if ( response.routeState == 'done') {
        done();
    } else {
      routeObj.state = response.routeState;
      showRouteUrlPrompt(self, routeObj, done);
    }
  });
}

var generateConfigRoute = function(configRoutes, route) {
  var ctrl = route.state + 'Ctrl.js';
  var view = route.state + '.html';
  configRoutes += 
    ".state(\'"+ route.state +"\', {\n" +
    "url: \'" + route.url + "',\n" +
    "templateUrl: \'templates/" + view + "\'\n,"+
    "controller: \'" + route.state +"',\n" +
    "abstract: " + route.abstract + ",\n" +
    "})";
  var ctrlFile = self.readFileAsString(path.join(__dirname, '../templates/scripts/ctrl.js'))
  ctrlFile = ctrlFile.replace("{{APP_NAME}}", self.appName);
  self.write(path.join(self.appPath, ctrl), ctrlFile);
  self.copy('../templates/views/empty.js', view);
}

module.exports = {
  ask: function(self) {
    var done = self.async();
    self.prompt([{
      type: 'confirm',
      name: 'routes',
      message: 'Would you like to configure your routes now ?'
    }], function (response) {
      if (response.routes == true) {
        self.routes = [];
        showRouteStatePrompt(self, done);
        addModelPrompt(addModelPrompt, done);
      } else {
        done();
      }
    }.bind(self));
  },
  install: function(self) {
    var routes = self.routes;
    var done = self.async();
    var configRoutes = '';
    if (routes.length > 0) {
      configRoutes = '$stateProvider\n';
    }
    for (var i = routes.length - 1; i >= 0; i--) {
      console.log('Installing route:' + routes[i].state);
      createService(configRoutes, routes[i]);
    };
    var file = self.readFileAsString(path.join(__dirname, '../templates/scripts/config.js'))
    file = file.replace("{{APP_NAME}}", self.appName);
    file = file.replace("{{ROUTES}}", configRoutes);
    self.write(path.join(self.appPath, 'config.js'), file);
    done();
  }
};
