/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.OfflineStore;
import com.parse.ParseClassName;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import java.util.ArrayList;
import java.util.List;

@ParseClassName(value="_Pin")
class ParsePin
extends ParseObject {
    private static final String KEY_NAME = "_name";
    private static final String KEY_OBJECTS = "_objects";

    static Task<ParsePin> getParsePin(final String name) {
        ParseQuery<ParsePin> query = ParseQuery.getQuery(ParsePin.class).whereEqualTo(KEY_NAME, name);
        return OfflineStore.getCurrent().findAsync(query, null, null).onSuccess((Continuation)new Continuation<List<ParsePin>, ParsePin>(){

            public ParsePin then(Task<List<ParsePin>> task) throws Exception {
                ParsePin pin = null;
                if (task.getResult() != null && ((List)task.getResult()).size() > 0) {
                    pin = (ParsePin)((List)task.getResult()).get(0);
                }
                if (pin == null) {
                    pin = ParseObject.create(ParsePin.class);
                    pin.setName(name);
                }
                return pin;
            }
        });
    }

    static <T extends ParseObject> Task<Void> pinAllObjectsAsync(String name, final List<T> objects) {
        if (objects == null || objects.size() == 0) {
            return Task.forResult(null);
        }
        return ParsePin.getParsePin(name).onSuccessTask((Continuation)new Continuation<ParsePin, Task<Void>>(){

            public Task<Void> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                OfflineStore store = OfflineStore.getCurrent();
                List<ParseObject> modified = pin.getObjects();
                if (modified == null) {
                    modified = new ArrayList<ParseObject>(objects);
                } else {
                    for (ParseObject object : objects) {
                        if (modified.contains(object)) continue;
                        modified.add(object);
                    }
                }
                pin.setObjects(modified);
                return store.saveLocallyAsync(pin, true);
            }
        });
    }

    static <T extends ParseObject> Task<Void> unpinAllObjectsAsync(String name, final List<T> objects) {
        if (objects == null || objects.size() == 0) {
            return Task.forResult(null);
        }
        return ParsePin.getParsePin(name).onSuccessTask((Continuation)new Continuation<ParsePin, Task<Void>>(){

            public Task<Void> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                OfflineStore store = OfflineStore.getCurrent();
                List<ParseObject> modified = pin.getObjects();
                if (modified == null) {
                    return Task.forResult(null);
                }
                modified.removeAll(objects);
                if (modified.size() == 0) {
                    return store.unpinAsync(pin);
                }
                pin.setObjects(modified);
                return store.saveLocallyAsync(pin, true);
            }
        });
    }

    static Task<Void> unpinAllObjectsAsync(String name) {
        return ParsePin.getParsePin(name).continueWithTask((Continuation)new Continuation<ParsePin, Task<Void>>(){

            public Task<Void> then(Task<ParsePin> task) throws Exception {
                if (task.isFaulted()) {
                    return task.makeVoid();
                }
                ParsePin pin = (ParsePin)task.getResult();
                return OfflineStore.getCurrent().unpinAsync(pin);
            }
        });
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.put(KEY_NAME, name);
    }

    public List<ParseObject> getObjects() {
        return this.getList(KEY_OBJECTS);
    }

    public void setObjects(List<ParseObject> objects) {
        this.put(KEY_OBJECTS, objects);
    }
}

