'use strict';
angular.module('{{APP_NAME}}.services').factory('AuthService', [
  '$q',
  '$resource',
  {{AUTH_PROVIDERS_QUOTED}}
  function ($q, $resource, {{AUTH_PROVIDERS}}) {
    var authenticateRequests = {
      'login': $resource('https://api.parse.com/1/login').get,
      'signup': $resource('https://api.parse.com/1/users').post
    };
    var providers = {
      {{AUTH_SERVICE_PROVIDER}}
    }
    var authenticate = function(request, provider, userData) {
      var q = $q.defer();
      providers[provider].login(userData)
      .then(function(authData) {
        authenticateRequests[request](authData)
        .$promise.then(function(user) {
          dataService.currentUser = user;
          q.resolve(user);
        }, function(data, status) {
          q.reject(data);
        });
      }, function(error) {
        q.reject(error);
      });
      return q.promise;
    }
    
    var dataService = {
      /* PROPERTIES */
      currentUser: null,
      /* METHOD */
      authenticate: authenticate
    };
    return dataService;
  }
]);