/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.parse.FindCallback;
import com.parse.ParseException;
import com.parse.ParseFile;
import com.parse.ParseImageView;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseQueryAdapter<T extends ParseObject>
extends BaseAdapter {
    private String textKey;
    private String imageKey;
    private int objectsPerPage = 25;
    private boolean paginationEnabled = true;
    private Drawable placeholder;
    private WeakHashMap<ParseImageView, Void> imageViewSet = new WeakHashMap();
    private WeakHashMap<DataSetObserver, Void> dataSetObservers = new WeakHashMap();
    private boolean autoload = true;
    private Context context;
    private List<T> objects = new ArrayList<T>();
    private int currentPage = 0;
    private Integer itemResourceId;
    private boolean hasNextPage = true;
    private QueryFactory<T> queryFactory;
    private List<OnQueryLoadListener<T>> onQueryLoadListeners = new ArrayList<OnQueryLoadListener<T>>();
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_NEXT_PAGE = 1;

    public ParseQueryAdapter(Context context, Class<? extends ParseObject> clazz) {
        this(context, ParseObject.getClassName(clazz));
    }

    public ParseQueryAdapter(Context context, final String className) {
        this(context, new QueryFactory<T>(){

            @Override
            public ParseQuery<T> create() {
                ParseQuery query = ParseQuery.getQuery(className);
                query.orderByDescending("createdAt");
                return query;
            }
        });
        if (className == null) {
            throw new RuntimeException("You need to specify a className for the ParseQueryAdapter");
        }
    }

    public ParseQueryAdapter(Context context, Class<? extends ParseObject> clazz, int itemViewResource) {
        this(context, ParseObject.getClassName(clazz), itemViewResource);
    }

    public ParseQueryAdapter(Context context, final String className, int itemViewResource) {
        this(context, (QueryFactory<T>)new QueryFactory<T>(){

            @Override
            public ParseQuery<T> create() {
                ParseQuery query = ParseQuery.getQuery(className);
                query.orderByDescending("createdAt");
                return query;
            }
        }, itemViewResource);
        if (className == null) {
            throw new RuntimeException("You need to specify a className for the ParseQueryAdapter");
        }
    }

    public ParseQueryAdapter(Context context, QueryFactory<T> queryFactory) {
        this(context, queryFactory, null);
    }

    public ParseQueryAdapter(Context context, QueryFactory<T> queryFactory, int itemViewResource) {
        this(context, queryFactory, (Integer)itemViewResource);
    }

    private ParseQueryAdapter(Context context, QueryFactory<T> queryFactory, Integer itemViewResource) {
        this.context = context;
        this.queryFactory = queryFactory;
        this.itemResourceId = itemViewResource;
    }

    public Context getContext() {
        return this.context;
    }

    public T getItem(int index) {
        if (index == this.getPaginationCellRow()) {
            return null;
        }
        return (T)((ParseObject)this.objects.get(index));
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (position == this.getPaginationCellRow()) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        this.dataSetObservers.put(observer, null);
        if (this.autoload) {
            this.loadObjects();
        }
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        super.unregisterDataSetObserver(observer);
        this.dataSetObservers.remove(observer);
    }

    public void clear() {
        this.objects.clear();
        this.notifyDataSetChanged();
        this.currentPage = 0;
    }

    public void loadObjects() {
        this.loadObjects(0, true);
    }

    private void loadObjects(final int page, final boolean shouldClear) {
        final ParseQuery<T> query = this.queryFactory.create();
        if (this.objectsPerPage > 0 && this.paginationEnabled) {
            this.setPageOnQuery(page, query);
        }
        this.notifyOnLoadingListeners();
        query.findInBackground(new FindCallback<T>(){

            @Override
            @SuppressLint(value={"ShowToast"})
            public void done(List<T> foundObjects, ParseException e) {
                if (query.getCachePolicy() == ParseQuery.CachePolicy.CACHE_ONLY && e != null && e.getCode() == 120) {
                    return;
                }
                if (e != null && (e.getCode() == 100 || e.getCode() != 120)) {
                    ParseQueryAdapter.this.hasNextPage = true;
                } else if (foundObjects != null) {
                    ParseQueryAdapter.this.currentPage = page;
                    ParseQueryAdapter.this.hasNextPage = foundObjects.size() > ParseQueryAdapter.this.objectsPerPage;
                    if (ParseQueryAdapter.this.paginationEnabled && foundObjects.size() > ParseQueryAdapter.this.objectsPerPage) {
                        foundObjects.remove(ParseQueryAdapter.this.objectsPerPage);
                    }
                    if (shouldClear) {
                        ParseQueryAdapter.this.objects.clear();
                    }
                    ParseQueryAdapter.this.objects.addAll(foundObjects);
                    ParseQueryAdapter.this.notifyDataSetChanged();
                }
                ParseQueryAdapter.this.notifyOnLoadedListeners(foundObjects, e);
            }
        });
    }

    public void loadNextPage() {
        this.loadObjects(this.currentPage + 1, false);
    }

    public int getCount() {
        int count = this.objects.size();
        if (this.shouldShowPaginationCell()) {
            ++count;
        }
        return count;
    }

    public View getItemView(T object, View v, ViewGroup parent) {
        TextView textView;
        if (v == null) {
            v = this.getDefaultView(this.context);
        }
        try {
            textView = (TextView)v.findViewById(16908308);
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Your object views must have a TextView whose id attribute is 'android.R.id.text1'", ex);
        }
        if (textView != null) {
            if (this.textKey == null) {
                textView.setText((CharSequence)((ParseObject)object).getObjectId());
            } else if (((ParseObject)object).get(this.textKey) != null) {
                textView.setText((CharSequence)((ParseObject)object).get(this.textKey).toString());
            } else {
                textView.setText(null);
            }
        }
        if (this.imageKey != null) {
            ParseImageView imageView;
            try {
                imageView = (ParseImageView)v.findViewById(16908294);
            }
            catch (ClassCastException ex) {
                throw new IllegalStateException("Your object views must have a ParseImageView whose id attribute is 'android.R.id.icon'", ex);
            }
            if (imageView == null) {
                throw new IllegalStateException("Your object views must have a ParseImageView whose id attribute is 'android.R.id.icon' if an imageKey is specified");
            }
            if (!this.imageViewSet.containsKey((Object)imageView)) {
                this.imageViewSet.put(imageView, null);
            }
            imageView.setPlaceholder(this.placeholder);
            imageView.setParseFile((ParseFile)((ParseObject)object).get(this.imageKey));
            imageView.loadInBackground();
        }
        return v;
    }

    public View getNextPageView(View v, ViewGroup parent) {
        if (v == null) {
            v = this.getDefaultView(this.context);
        }
        TextView textView = (TextView)v.findViewById(16908308);
        textView.setText((CharSequence)"Load more...");
        return v;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        if (this.getItemViewType(position) == 1) {
            View nextPageView = this.getNextPageView(convertView, parent);
            nextPageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ParseQueryAdapter.this.loadNextPage();
                }
            });
            return nextPageView;
        }
        return this.getItemView(this.getItem(position), convertView, parent);
    }

    protected void setPageOnQuery(int page, ParseQuery<T> query) {
        query.setLimit(this.objectsPerPage + 1);
        query.setSkip(page * this.objectsPerPage);
    }

    public void setTextKey(String textKey) {
        this.textKey = textKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    public void setObjectsPerPage(int objectsPerPage) {
        this.objectsPerPage = objectsPerPage;
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setPaginationEnabled(boolean paginationEnabled) {
        this.paginationEnabled = paginationEnabled;
    }

    public void setPlaceholder(Drawable placeholder) {
        if (this.placeholder == placeholder) {
            return;
        }
        this.placeholder = placeholder;
        for (ParseImageView imageView : this.imageViewSet.keySet()) {
            if (imageView == null) continue;
            imageView.setPlaceholder(this.placeholder);
        }
    }

    public void setAutoload(boolean autoload) {
        if (this.autoload == autoload) {
            return;
        }
        this.autoload = autoload;
        if (this.autoload && !this.dataSetObservers.isEmpty() && this.objects.isEmpty()) {
            this.loadObjects();
        }
    }

    public void addOnQueryLoadListener(OnQueryLoadListener<T> listener) {
        this.onQueryLoadListeners.add(listener);
    }

    public void removeOnQueryLoadListener(OnQueryLoadListener<T> listener) {
        this.onQueryLoadListeners.remove(listener);
    }

    private View getDefaultView(Context context) {
        if (this.itemResourceId != null) {
            return View.inflate((Context)context, (int)this.itemResourceId, null);
        }
        LinearLayout view = new LinearLayout(context);
        view.setPadding(8, 4, 8, 4);
        ParseImageView imageView = new ParseImageView(context);
        imageView.setId(16908294);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(50, 50));
        view.addView((View)imageView);
        TextView textView = new TextView(context);
        textView.setId(16908308);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        textView.setPadding(8, 0, 0, 0);
        view.addView((View)textView);
        return view;
    }

    private int getPaginationCellRow() {
        return this.objects.size();
    }

    private boolean shouldShowPaginationCell() {
        return this.paginationEnabled && this.objects.size() > 0 && this.hasNextPage;
    }

    private void notifyOnLoadingListeners() {
        for (OnQueryLoadListener<T> listener : this.onQueryLoadListeners) {
            listener.onLoading();
        }
    }

    private void notifyOnLoadedListeners(List<T> objects, Exception e) {
        for (OnQueryLoadListener<T> listener : this.onQueryLoadListeners) {
            listener.onLoaded(objects, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnQueryLoadListener<T extends ParseObject> {
        public void onLoading();

        public void onLoaded(List<T> var1, Exception var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface QueryFactory<T extends ParseObject> {
        public ParseQuery<T> create();
    }
}

