
var path = require('path');

var createService = function(self, provider) {
  var file = self.readFileAsString(path.join(__dirname, '../templates/scripts/' + provider + 'AuthService.js'))
  file = file.replace(new RegExp("{{APP_NAME}}", 'g'), self.appName);  
  self.write(path.join(self.appPath, provider+'Service.js'), file);
}

module.exports = {
  prompts: [{
    type: 'checkbox',
    name: 'providers',
    message: 'Which Authentification provider would you like to include?',
    choices: [{
      value: 'twitter',
      name: 'Twitter',
      checked: false
    },
    {
      value: 'facebook',      
      name: 'Facebook',
      checked: false
    },
    {
      value: 'username',
      name: 'Username/Password',
      checked: false
    }
    ]
  }],
  install: function(self, choices, done) {
    var promises = [];
    for (var i = choices.length - 1; i >= 0; i--) {
      console.log('Choice:' + choices[i]);
      createService(self, choices[i]);
    };
    done();
  },


};
