/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.AnonymousAuthenticationProvider;
import com.parse.LogInCallback;
import com.parse.Parse;
import com.parse.ParseUser;
import org.json.JSONException;

public final class ParseAnonymousUtils {
    private static AnonymousAuthenticationProvider provider;
    static final String AUTH_TYPE_ANONYMOUS = "anonymous";
    static final String SERVICE_NAME_ANONYMOUS = "anonymous";

    private static AnonymousAuthenticationProvider getProvider() {
        if (provider == null) {
            provider = new AnonymousAuthenticationProvider();
            ParseUser.registerAuthenticationProvider(provider);
        }
        return provider;
    }

    public static boolean isLinked(ParseUser user) {
        return user.getLinkedServiceNames().contains("anonymous");
    }

    public static Task<ParseUser> logInInBackground() {
        return ParseUser.logInWithAsync(ParseAnonymousUtils.getProvider().getAuthType());
    }

    public static void logIn(LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseAnonymousUtils.logInInBackground(), callback);
    }

    static ParseUser lazyLogIn() {
        try {
            AnonymousAuthenticationProvider provider = ParseAnonymousUtils.getProvider();
            return ParseUser.logInLazyUser(provider.getAuthType(), provider.getAuthData());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private ParseAnonymousUtils() {
    }
}

