
var path = require('path');

var createService = function(self, provider) {
  var file = self.readFileAsString(path.join(__dirname, '../templates/scripts/' + provider + 'AuthService.js'))
  file = file.replace(new RegExp("{{APP_NAME}}", 'g'), self.appName);  
  var filePath = path.join(self.servicePath, provider+'Service.js');
  self.write(filePath, file);
  self.scriptsFile.push(filePath);
}

var prompt = [{
    type: 'checkbox',
    name: 'providers',
    message: 'Which Authentification provider would you like to include?',
    choices: [{
      value: 'twitter',
      name: 'Twitter',
      checked: false
    },
    {
      value: 'facebook',      
      name: 'Facebook',
      checked: false
    },
    {
      value: 'username',
      name: 'Username/Password',
      checked: false
    }
  ]
}];

module.exports = {
  ask: function(self) {
    var done = self.async();
    self.prompt(prompt, function (props) {
      self.auth = props.providers;
      done();
    }.bind(self));
  },
  install: function(self) {
    var choices = self.auth;
    if (choices) {
      var done = self.async();
      for (var i = choices.length - 1; i >= 0; i--) {
        console.log('Choice:' + choices[i]);
        createService(self, choices[i]);
      };
      var file = self.readFileAsString(path.join(__dirname, '../templates/scripts/AuthService.js'))
      file = file.replace(new RegExp("{{APP_NAME}}", 'g'), self.appName);  
      var filePath = path.join(self.servicePath, 'AuthService.js');
      self.write(filePath, file);
      self.scriptsFile.push(filePath);
      done();      
    }
  }
};
