/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.CountCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseRelation;
import com.parse.ParseUser;
import com.parse.PointerEncodingStrategy;
import com.parse.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseQuery<T extends ParseObject> {
    private static final String TAG = "com.parse.ParseQuery";
    private String className;
    private QueryConstraints where;
    private ArrayList<String> include;
    private ArrayList<String> selectedKeys;
    private int limit;
    private boolean trace;
    private int skip;
    private String order;
    private long queryStart;
    private long querySent;
    private long queryReceived;
    private long objectsParsed;
    private Object isRunningLock = new Object();
    private ParseCommand currentCommand = null;
    private boolean isRunning = false;
    private HashMap<String, Object> extraOptions = null;
    private CachePolicy cachePolicy;
    private long maxCacheAge;

    public static <T extends ParseObject> ParseQuery<T> or(List<ParseQuery<T>> queries) {
        ArrayList<ParseQuery<T>> localList = new ArrayList<ParseQuery<T>>();
        String className = null;
        for (int i = 0; i < queries.size(); ++i) {
            if (className != null && !queries.get((int)i).className.equals(className)) {
                throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
            }
            className = queries.get((int)i).className;
            localList.add(queries.get(i));
        }
        if (localList.size() == 0) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ParseQuery<T> value = new ParseQuery<T>(className);
        return super.whereSatifiesAnyOf(localList);
    }

    public ParseQuery(Class<T> subclass) {
        this(ParseObject.getClassName(subclass));
    }

    public ParseQuery(String theClassName) {
        this.className = theClassName;
        this.limit = -1;
        this.skip = 0;
        this.where = new QueryConstraints();
        this.include = new ArrayList();
        this.cachePolicy = CachePolicy.IGNORE_CACHE;
        this.maxCacheAge = Long.MAX_VALUE;
        this.trace = false;
        this.extraOptions = new HashMap();
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(Class<T> subclass) {
        return new ParseQuery<T>(subclass);
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(String className) {
        return new ParseQuery<T>(className);
    }

    @Deprecated
    public static ParseQuery<ParseUser> getUserQuery() {
        return ParseUser.getQuery();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Object object = this.isRunningLock;
        synchronized (object) {
            if (this.isRunning) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
            }
        }
    }

    QueryConstraints getConstraints() {
        return this.where;
    }

    JSONObject toREST() {
        JSONObject params = new JSONObject();
        try {
            params.put("className", (Object)this.className);
            params.put("where", Parse.encode(this.where, PointerEncodingStrategy.get()));
            if (this.limit >= 0) {
                params.put("limit", this.limit);
            }
            if (this.skip > 0) {
                params.put("skip", this.skip);
            }
            if (this.order != null) {
                params.put("order", (Object)this.order);
            }
            if (!this.include.isEmpty()) {
                params.put("include", (Object)Parse.join(this.include, ","));
            }
            if (this.selectedKeys != null) {
                params.put("fields", (Object)Parse.join(this.selectedKeys, ","));
            }
            if (this.trace) {
                params.put("trace", (Object)"1");
            }
            for (String key : this.extraOptions.keySet()) {
                params.put(key, Parse.encode(this.extraOptions.get(key), PointerEncodingStrategy.get()));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return params;
    }

    private JSONObject toJSON() {
        JSONObject json = this.toREST();
        try {
            if (!json.isNull("where")) {
                json.put("data", json.remove("where"));
            }
            json.put("classname", json.remove("className"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    private ParseCommand makeFindCommand(String sessionToken) {
        ParseCommand command = new ParseCommand("find", sessionToken);
        JSONObject params = this.toJSON();
        Iterator keys = params.keys();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                command.put(key, params.get(key).toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return command;
    }

    private List<T> convertFindResponse(JSONObject response) throws JSONException {
        ArrayList answer = new ArrayList();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            Parse.logD(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className");
            if (resultClassName.equals("")) {
                resultClassName = this.className;
            }
            for (int i = 0; i < results.length(); ++i) {
                JSONObject json = results.getJSONObject(i);
                Object object = ParseObject.fromJSON(json, resultClassName, this.selectedKeys == null);
                answer.add(object);
            }
        }
        this.objectsParsed = System.nanoTime();
        if (response.has("trace")) {
            Object serverTrace = response.get("trace");
            String fullTrace = "Query pre-processing took " + (this.querySent - this.queryStart) + " milliseconds\n";
            fullTrace = fullTrace + serverTrace + "\n";
            fullTrace = fullTrace + "Client side parsing took " + (this.objectsParsed - this.queryReceived) + " millisecond\n";
            Parse.logD("ParseQuery", fullTrace);
        }
        return answer;
    }

    private <TResult> Task<TResult> runCommandWithPolicyAsync(final CommandDelegate<TResult> c, CachePolicy policy) {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetworkAsync(true);
            }
            case CACHE_ONLY: {
                return c.runFromCacheAsync();
            }
            case CACHE_ELSE_NETWORK: {
                return c.runFromCacheAsync().continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    @Override
                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException) {
                            return c.runOnNetworkAsync(true);
                        }
                        return task;
                    }
                });
            }
            case NETWORK_ELSE_CACHE: {
                return c.runOnNetworkAsync(false).continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    @Override
                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 100) {
                            return c.runFromCacheAsync();
                        }
                        return task;
                    }
                });
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)this.cachePolicy));
    }

    private Task<Integer> countWithCachePolicyAsync(CachePolicy policy) {
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Task<Integer> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.countFromNetworkAsync();
            }

            @Override
            public Task<Integer> runFromCacheAsync() {
                return Task.call(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ParseQuery.this.countFromCache();
                    }
                }, ParseCommand.networkThreadPool);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    Task<List<T>> findWithCachePolicyAsync(CachePolicy policy) {
        CommandDelegate callbacks = new CommandDelegate<List<T>>(){

            @Override
            public Task<List<T>> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.findFromNetworkAsync(retry);
            }

            @Override
            public Task<List<T>> runFromCacheAsync() {
                return Task.call(new Callable<List<T>>(){

                    @Override
                    public List<T> call() throws Exception {
                        return ParseQuery.this.findFromCache();
                    }
                }, ParseCommand.networkThreadPool);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    private Task<T> getFirstWithCachePolicyAsync(CachePolicy policy) {
        this.limit = -1;
        return this.findWithCachePolicyAsync(policy).continueWith(new Continuation<List<T>, T>(){

            @Override
            public T then(Task<List<T>> task) throws Exception {
                if (task.isFaulted()) {
                    throw task.getError();
                }
                if (task.getResult() != null && task.getResult().size() > 0) {
                    return (ParseObject)task.getResult().get(0);
                }
                throw new ParseException(101, "no results found for query");
            }
        });
    }

    private Task<T> getWithCachePolicyAsync(String objectId, CachePolicy policy) {
        this.skip = -1;
        this.where = new QueryConstraints();
        this.where.put("objectId", objectId);
        return this.getFirstWithCachePolicyAsync(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.isRunningLock;
        synchronized (object) {
            if (this.currentCommand != null) {
                this.currentCommand.cancel();
                this.currentCommand = null;
            }
            this.isRunning = false;
        }
    }

    public List<T> find() throws ParseException {
        return (List)Parse.waitForTask(this.doWithRunningCheck(new Callable<Task<List<T>>>(){

            @Override
            public Task<List<T>> call() throws Exception {
                return ParseQuery.this.findWithCachePolicyAsync(ParseQuery.this.cachePolicy);
            }
        }));
    }

    public T getFirst() throws ParseException {
        return (T)((ParseObject)Parse.waitForTask(this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getFirstWithCachePolicyAsync(ParseQuery.this.cachePolicy);
            }
        })));
    }

    private Task<List<T>> findFromNetworkAsync(final boolean shouldRetry) {
        this.currentCommand = this.makeFindCommand(ParseUser.getCurrentSessionToken());
        return Task.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (shouldRetry) {
                    ParseQuery.this.currentCommand.enableRetrying();
                }
                return null;
            }
        }).onSuccessTask(new Continuation<Void, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<Void> task) throws Exception {
                ArrayList answer = new ArrayList();
                if (ParseQuery.this.currentCommand == null) {
                    return Task.forResult(answer);
                }
                boolean caching = ParseQuery.this.cachePolicy != CachePolicy.IGNORE_CACHE;
                ParseQuery.this.querySent = System.nanoTime();
                return ParseQuery.this.currentCommand.performAsync(caching).onSuccess(new Continuation<Object, List<T>>(){

                    @Override
                    public List<T> then(Task<Object> task) throws Exception {
                        ParseQuery.this.queryReceived = System.nanoTime();
                        return ParseQuery.this.convertFindResponse((JSONObject)task.getResult());
                    }
                });
            }
        });
    }

    public void setCachePolicy(CachePolicy newCachePolicy) {
        this.checkIfRunning();
        this.cachePolicy = newCachePolicy;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void setMaxCacheAge(long maxAgeInMilliseconds) {
        this.maxCacheAge = maxAgeInMilliseconds;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    private List<T> findFromCache() throws ParseException {
        String cacheKey = this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return this.convertFindResponse(object);
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    private Integer countFromCache() throws ParseException {
        String cacheKey = this.makeCountCommand(ParseUser.getCurrentSessionToken()).getCacheKey();
        Object cached = Parse.jsonFromKeyValueCache(cacheKey, this.maxCacheAge);
        if (cached == null) {
            throw new ParseException(120, "results not cached");
        }
        if (!(cached instanceof JSONObject)) {
            throw new ParseException(120, "the cache contains the wrong datatype");
        }
        JSONObject object = (JSONObject)cached;
        try {
            return object.getInt("count");
        }
        catch (JSONException e) {
            throw new ParseException(120, "the cache contains corrupted json");
        }
    }

    private <TResult> Task<TResult> doWithRunningCheck(Callable<Task<TResult>> runnable) {
        this.checkIfRunning(true);
        Task<TResult> task = null;
        try {
            task = runnable.call();
        }
        catch (Exception e) {
            task = Task.forError(e);
        }
        return task.continueWithTask(new Continuation<TResult, Task<TResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task<TResult> then(Task<TResult> task) throws Exception {
                Object object = ParseQuery.this.isRunningLock;
                synchronized (object) {
                    ParseQuery.this.isRunning = false;
                    ParseQuery.this.currentCommand = null;
                }
                return task;
            }
        });
    }

    private <TResult> void doInBackground(final CallableWithCachePolicy<Task<TResult>> callable, final ParseCallback<TResult> callback) {
        Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<TResult>>(){

            @Override
            public Task<TResult> call() throws Exception {
                Task<Object> findTask;
                if (ParseQuery.this.cachePolicy == CachePolicy.CACHE_THEN_NETWORK) {
                    findTask = (Task)callable.call(CachePolicy.CACHE_ONLY);
                    findTask = Parse.callbackOnMainThreadAsync(findTask, callback);
                    findTask = findTask.continueWithTask(new Continuation<TResult, Task<TResult>>(){

                        @Override
                        public Task<TResult> then(Task<TResult> task) throws Exception {
                            if (task.isCancelled()) {
                                return task;
                            }
                            return (Task)callable.call(CachePolicy.NETWORK_ONLY);
                        }
                    });
                } else {
                    findTask = (Task)callable.call(ParseQuery.this.cachePolicy);
                }
                return findTask;
            }
        }), callback);
    }

    public void findInBackground(FindCallback<T> callback) {
        this.queryStart = System.nanoTime();
        this.doInBackground(new CallableWithCachePolicy<Task<List<T>>>(){

            @Override
            public Task<List<T>> call(CachePolicy cachePolicy) {
                return ParseQuery.this.findWithCachePolicyAsync(cachePolicy);
            }
        }, callback);
    }

    public void getFirstInBackground(GetCallback<T> callback) {
        this.doInBackground(new CallableWithCachePolicy<Task<T>>(){

            @Override
            public Task<T> call(CachePolicy cachePolicy) {
                return ParseQuery.this.getFirstWithCachePolicyAsync(cachePolicy);
            }
        }, callback);
    }

    private ParseCommand makeCountCommand(String sessionToken) {
        ParseCommand command = this.makeFindCommand(sessionToken);
        command.put("limit", 0);
        command.put("count", 1);
        return command;
    }

    public int count() throws ParseException {
        return Parse.waitForTask(this.doWithRunningCheck(new Callable<Task<Integer>>(){

            @Override
            public Task<Integer> call() throws Exception {
                return ParseQuery.this.countWithCachePolicyAsync(ParseQuery.this.cachePolicy);
            }
        }));
    }

    private Task<Integer> countFromNetworkAsync() {
        boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        this.currentCommand = this.makeCountCommand(ParseUser.getCurrentSessionToken());
        return this.currentCommand.performAsync(caching).continueWith(new Continuation<Object, Integer>(){

            @Override
            public Integer then(Task<Object> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    public void countInBackground(CountCallback callback) {
        this.queryStart = System.nanoTime();
        this.doInBackground(new CallableWithCachePolicy<Task<Integer>>(){

            @Override
            public Task<Integer> call(CachePolicy cachePolicy) {
                return ParseQuery.this.countWithCachePolicyAsync(cachePolicy);
            }
        }, callback);
    }

    public T get(final String theObjectId) throws ParseException {
        return (T)((ParseObject)Parse.waitForTask(this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getWithCachePolicyAsync(theObjectId, ParseQuery.this.cachePolicy);
            }
        })));
    }

    public boolean hasCachedResult() {
        String raw = Parse.loadFromKeyValueCache(this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey(), this.maxCacheAge);
        return raw != null;
    }

    public void clearCachedResult() {
        Parse.clearFromKeyValueCache(this.makeFindCommand(ParseUser.getCurrentSessionToken()).getCacheKey());
    }

    public static void clearAllCachedResults() {
        Parse.clearCacheDir();
    }

    public void getInBackground(final String objectId, GetCallback<T> callback) {
        this.doInBackground(new CallableWithCachePolicy<Task<T>>(){

            @Override
            public Task<T> call(CachePolicy cachePolicy) {
                return ParseQuery.this.getWithCachePolicyAsync(objectId, cachePolicy);
            }
        }, callback);
    }

    public ParseQuery<T> whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.where.put(key, value);
        return this;
    }

    private void addCondition(String key, String condition, Object value) {
        Object existingValue;
        this.checkIfRunning();
        KeyConstraints whereValue = null;
        if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof KeyConstraints) {
            whereValue = (KeyConstraints)existingValue;
        }
        if (whereValue == null) {
            whereValue = new KeyConstraints();
        }
        whereValue.put(condition, value);
        this.where.put(key, whereValue);
    }

    public ParseQuery<T> whereLessThan(String key, Object value) {
        this.addCondition(key, "$lt", value);
        return this;
    }

    public ParseQuery<T> whereNotEqualTo(String key, Object value) {
        this.addCondition(key, "$ne", value);
        return this;
    }

    public ParseQuery<T> whereGreaterThan(String key, Object value) {
        this.addCondition(key, "$gt", value);
        return this;
    }

    public ParseQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$lte", value);
        return this;
    }

    public ParseQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$gte", value);
        return this;
    }

    public ParseQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.addCondition(key, "$in", new ArrayList<Object>(values));
        return this;
    }

    public ParseQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.addCondition(key, "$all", new ArrayList(values));
        return this;
    }

    public ParseQuery<T> whereMatchesQuery(String key, ParseQuery<?> query) {
        this.addCondition(key, "$inQuery", query);
        return this;
    }

    public ParseQuery<T> whereDoesNotMatchQuery(String key, ParseQuery<?> query) {
        this.addCondition(key, "$notInQuery", query);
        return this;
    }

    public ParseQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$select", condition);
        return this;
    }

    public ParseQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.addCondition(key, "$dontSelect", condition);
        return this;
    }

    private ParseQuery<T> whereSatifiesAnyOf(List<ParseQuery<? extends T>> queries) {
        ArrayList<QueryConstraints> constraints = new ArrayList<QueryConstraints>();
        for (ParseQuery<T> query : queries) {
            if (query.limit >= 0) {
                throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
            }
            if (query.skip > 0) {
                throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
            }
            if (query.order != null) {
                throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
            }
            if (!query.include.isEmpty()) {
                throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
            }
            if (query.selectedKeys != null) {
                throw new IllegalArgumentException("Cannot have an selectKeys in sub queries of an 'OR' query");
            }
            constraints.add(query.getConstraints());
        }
        this.where.put("$or", constraints);
        return this;
    }

    public ParseQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.addCondition(key, "$nin", new ArrayList<Object>(values));
        return this;
    }

    public ParseQuery<T> whereNear(String key, ParseGeoPoint point) {
        this.addCondition(key, "$nearSphere", point);
        return this;
    }

    public ParseQuery<T> whereWithinMiles(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_MILE);
        return this;
    }

    public ParseQuery<T> whereWithinKilometers(String key, ParseGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_KM);
        return this;
    }

    public ParseQuery<T> whereWithinRadians(String key, ParseGeoPoint point, double maxDistance) {
        this.addCondition(key, "$nearSphere", point);
        this.addCondition(key, "$maxDistance", maxDistance);
        return this;
    }

    public ParseQuery<T> whereWithinGeoBox(String key, ParseGeoPoint southwest, ParseGeoPoint northeast) {
        ArrayList<ParseGeoPoint> array = new ArrayList<ParseGeoPoint>();
        array.add(southwest);
        array.add(northeast);
        HashMap<String, ArrayList<ParseGeoPoint>> dictionary = new HashMap<String, ArrayList<ParseGeoPoint>>();
        dictionary.put("$box", array);
        this.addCondition(key, "$within", dictionary);
        return this;
    }

    public ParseQuery<T> whereMatches(String key, String regex) {
        this.addCondition(key, "$regex", regex);
        return this;
    }

    public ParseQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public ParseQuery<T> whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public void include(String key) {
        this.checkIfRunning();
        this.include.add(key);
    }

    List<String> getIncludes() {
        return Collections.unmodifiableList(this.include);
    }

    public void selectKeys(Collection<String> keys) {
        this.checkIfRunning();
        if (this.selectedKeys == null) {
            this.selectedKeys = new ArrayList();
        }
        this.selectedKeys.addAll(keys);
    }

    public ParseQuery<T> whereExists(String key) {
        this.addCondition(key, "$exists", true);
        return this;
    }

    public ParseQuery<T> whereDoesNotExist(String key) {
        this.addCondition(key, "$exists", false);
        return this;
    }

    ParseQuery<T> whereRelatedTo(ParseObject parent, String key) {
        this.where.put("$relatedTo", new RelationConstraint(key, parent));
        return this;
    }

    ParseQuery<T> redirectClassNameForKey(String key) {
        this.extraOptions.put("redirectClassNameForKey", key);
        return this;
    }

    public ParseQuery<T> orderByAscending(String key) {
        this.checkIfRunning();
        this.order = key;
        return this;
    }

    public ParseQuery<T> addAscendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? key : this.order + "," + key;
        return this;
    }

    public ParseQuery<T> orderByDescending(String key) {
        this.checkIfRunning();
        this.order = "-" + key;
        return this;
    }

    public ParseQuery<T> addDescendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? "-" + key : this.order + ",-" + key;
        return this;
    }

    String[] sortKeys() {
        if (this.order == null) {
            return new String[0];
        }
        return this.order.split(",");
    }

    public void setLimit(int newLimit) {
        this.checkIfRunning();
        this.limit = newLimit;
    }

    public void setTrace(boolean shouldTrace) {
        this.trace = shouldTrace;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setSkip(int newSkip) {
        this.checkIfRunning();
        this.skip = newSkip;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CallableWithCachePolicy<TResult> {
        public TResult call(CachePolicy var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CommandDelegate<T> {
        public Task<T> runOnNetworkAsync(boolean var1);

        public Task<T> runFromCacheAsync();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RelationConstraint {
        private String key;
        private ParseObject object;

        public RelationConstraint(String key, ParseObject object) {
            if (key == null || object == null) {
                throw new IllegalArgumentException("Arguments must not be null.");
            }
            this.key = key;
            this.object = object;
        }

        public String getKey() {
            return this.key;
        }

        public ParseObject getObject() {
            return this.object;
        }

        public ParseRelation<ParseObject> getRelation() {
            return this.object.getRelation(this.key);
        }

        public JSONObject encode(ParseObjectEncodingStrategy objectEncoder) {
            JSONObject json = new JSONObject();
            try {
                json.put("key", (Object)this.key);
                json.put("object", (Object)objectEncoder.encodeRelatedObject(this.object));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return json;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyConstraints
    extends HashMap<String, Object> {
        KeyConstraints() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryConstraints
    extends HashMap<String, Object> {
        QueryConstraints() {
        }
    }
}

