/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.text.format.Time;
import android.util.Log;
import com.parse.ACRA;
import com.parse.Compatibility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

class DropBoxCollector {
    private static final String[] SYSTEM_TAGS = new String[]{"system_app_anr", "system_app_wtf", "system_app_crash", "system_server_anr", "system_server_wtf", "system_server_crash", "BATTERY_DISCHARGE_INFO", "SYSTEM_RECOVERY_LOG", "SYSTEM_BOOT", "SYSTEM_LAST_KMSG", "APANIC_CONSOLE", "APANIC_THREADS", "SYSTEM_RESTART", "SYSTEM_TOMBSTONE", "data_app_strictmode"};

    DropBoxCollector() {
    }

    public static String read(Context context, String[] additionalTags) {
        block16: {
            try {
                String serviceName = Compatibility.getDropBoxServiceName();
                if (serviceName == null) break block16;
                StringBuilder dropboxContent = new StringBuilder();
                Object dropbox = context.getSystemService(serviceName);
                Method getNextEntry = dropbox.getClass().getMethod("getNextEntry", String.class, Long.TYPE);
                if (getNextEntry != null) {
                    Time timer = new Time();
                    timer.setToNow();
                    timer.minute -= ACRA.getConfig().dropboxCollectionMinutes();
                    timer.normalize(false);
                    long time = timer.toMillis(false);
                    ArrayList<Object> tags = ACRA.getConfig().includeDropBoxSystemTags() ? new ArrayList<String>(Arrays.asList(SYSTEM_TAGS)) : new ArrayList();
                    if (additionalTags != null && additionalTags.length > 0) {
                        tags.addAll(Arrays.asList(additionalTags));
                    }
                    String text = null;
                    Object entry = null;
                    if (tags.size() > 0) {
                        for (String string : tags) {
                            long msec = time;
                            dropboxContent.append("Tag: ").append(string).append('\n');
                            entry = getNextEntry.invoke(dropbox, string, msec);
                            if (entry != null) {
                                Method getText = entry.getClass().getMethod("getText", Integer.TYPE);
                                Method getTimeMillis = entry.getClass().getMethod("getTimeMillis", null);
                                Method close = entry.getClass().getMethod("close", null);
                                while (entry != null) {
                                    msec = (Long)getTimeMillis.invoke(entry, (Object[])null);
                                    timer.set(msec);
                                    dropboxContent.append("@").append(timer.format2445()).append('\n');
                                    text = (String)getText.invoke(entry, 500);
                                    if (text != null) {
                                        dropboxContent.append("Text: ").append(text).append('\n');
                                    } else {
                                        dropboxContent.append("Not Text!").append('\n');
                                    }
                                    close.invoke(entry, (Object[])null);
                                    entry = getNextEntry.invoke(dropbox, string, msec);
                                }
                                continue;
                            }
                            dropboxContent.append("Nothing.").append('\n');
                        }
                    } else {
                        dropboxContent.append("No tag configured for collection.");
                    }
                }
                return dropboxContent.toString();
            }
            catch (SecurityException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
            catch (NoSuchMethodException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
            catch (IllegalArgumentException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
            catch (IllegalAccessException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
            catch (InvocationTargetException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
            catch (NoSuchFieldException e) {
                Log.i((String)"CrashReporting", (String)"DropBoxManager not available.");
            }
        }
        return "N/A";
    }
}

