/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.parse.ACRA;
import com.parse.ConfigurationInspector;
import com.parse.CrashReportData;
import com.parse.CustomReportDataSupplier;
import com.parse.DeviceFeaturesCollector;
import com.parse.DropBoxCollector;
import com.parse.DumpSysCollector;
import com.parse.FileProvider;
import com.parse.Installation;
import com.parse.LogBridge;
import com.parse.LogCatCollector;
import com.parse.NonCrashException;
import com.parse.PackageManagerWrapper;
import com.parse.ProcFileReader;
import com.parse.ReflectionCollector;
import com.parse.ReportField;
import com.parse.ReportSender;
import com.parse.ReportSenderException;
import com.parse.SettingsCollector;
import com.parse.SimpleTraceLogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    public static final String REPORTFILE_EXTENSION = ".stacktrace";
    public static final String TEMP_REPORTFILE_EXTENSION = ".temp_stacktrace";
    public static final String ACRA_DIRNAME = "cr/reports";
    public static final long MAX_REPORT_AGE = 86400000L;
    public static final long DEFAULT_MAX_REPORT_SIZE = 51200L;
    public static final String PREALLOCATED_REPORTFILE = "reportfile.prealloc";
    public static final long PREALLOCATED_FILESIZE = 51200L;
    public static final String DUMP_DIR = "cr/minidumps";
    public static final String CRASH_ATTACHMENT_DUMMY_STACKTRACE = "crash attachment";
    public static final String SIGQUIT_DIR = "traces";
    public static final String DUMPFILE_EXTENSION = ".dmp";
    public static final long NATIVE_MAX_REPORT_SIZE = 512000L;
    public static final long SIGQUIT_MAX_REPORT_SIZE = 122880L;
    private static final Pattern VERSION_CODE_REGEX = Pattern.compile("^\\d+-[a-zA-Z0-9_\\-]+-(\\d+)\\.(temp_stacktrace|stacktrace)$");
    private static final long MIN_TEMP_REPORT_AGE = 600000L;
    private long mMaxReportSize = 51200L;
    private static final String mInternalException = "ACRA_INTERNAL=java.lang.Exception: An exception occurred while trying to collect data about an ACRA internal error\n\tat com.parse.acra.ErrorReporter.handleException(ErrorReporter.java:810)\n\tat com.parse.acra.ErrorReporter.handleException(ErrorReporter.java:866)\n\tat com.parse.acra.ErrorReporter.uncaughtException(ErrorReporter.java:666)\n\tat java.lang.ThreadGroup.uncaughtException(ThreadGroup.java:693)\n\tat java.lang.ThreadGroup.uncaughtException(ThreadGroup.java:690)\n";
    private static final String IS_PROCESSING_ANOTHER_EXCEPTION = "IS_PROCESSING_ANOTHER_EXCEPTION";
    private static final String ANDROID_RUNTIME_DALVIK = "DALVIK";
    private static final String ANDROID_RUNTIME_ART = "ART";
    private static final String ANDROID_RUNTIME_UNKNOWN = "UNKNOWN";
    private static final String KNOWN_ART_JAR = "/system/framework/core-libart.jar";
    private static final String KNOWN_DALVIK_JAR = "/system/framework/core.jar";
    private static final String JAVA_BOOT_CLASS_PATH = "java.boot.class.path";
    private boolean mHasNativeCrashDumpOnInit = false;
    private ArrayList<ReportSender> mReportSenders = new ArrayList();
    private final Map<ReportField, String> mConstantFields = new HashMap<ReportField, String>();
    private final Map<ReportField, String> mDeviceSpecificFields = new HashMap<ReportField, String>();
    private PackageManagerWrapper mPackageManager;
    private static final CrashReportType[] ALL_REPORT_TYPES = new CrashReportType[]{CrashReportType.ACRA_CRASH_REPORT, CrashReportType.NATIVE_CRASH_REPORT, CrashReportType.ANR_REPORT};
    private FileProvider mFileProvider;
    public static final int MAX_SEND_REPORTS = 5;
    Map<String, String> mInstanceCustomParameters = new ConcurrentHashMap<String, String>();
    Map<String, CustomReportDataSupplier> mInstanceLazyCustomParameters = new ConcurrentHashMap<String, CustomReportDataSupplier>();
    private boolean mCurrentlyProcessingOOM = false;
    private final Object mShouldContinueProcessingExceptionLock = new Object();
    private Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private static ErrorReporter mInstanceSingleton;
    private Context mContext;
    private File preallocFile = null;
    private static int DEFAULT_TRACE_COUNT_LIMIT;
    private static int MAX_TRACE_COUNT_LIMIT;
    private final SimpleTraceLogger activityLogger = new SimpleTraceLogger(MAX_TRACE_COUNT_LIMIT);
    private String mAppVersionCode;
    private String mAppVersionName;
    private volatile String mUserId;
    private volatile boolean sendInMemoryReport = false;
    private boolean processNameByAmsReady;
    private String processNameByAms;
    private final Time mAppStartDate = new Time();
    private boolean usePreallocatedFile = false;
    private boolean mIsInternalBuild;
    private LogBridge mLogBridge;
    private static AtomicBoolean mProcessingCrash;

    ErrorReporter() {
    }

    public LogBridge getLogBridge() {
        return this.mLogBridge;
    }

    public void setLogBridge(LogBridge bridge) {
        this.mLogBridge = bridge;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public String putCustomData(String key, String value) {
        if (value != null) {
            return this.mInstanceCustomParameters.put(key, value);
        }
        return this.removeCustomData(key);
    }

    public String removeCustomData(String key) {
        return this.mInstanceCustomParameters.remove(key);
    }

    public String getCustomData(String key) {
        return this.mInstanceCustomParameters.get(key);
    }

    public void putLazyCustomData(String key, CustomReportDataSupplier valueSupplier) {
        this.mInstanceLazyCustomParameters.put(key, valueSupplier);
    }

    public String dumpCustomDataToString(Map<String, String> extras, Throwable throwable) {
        StringBuilder customInfo = new StringBuilder();
        this.dumpCustomDataMap(customInfo, this.mInstanceCustomParameters);
        if (extras != null) {
            this.dumpCustomDataMap(customInfo, extras);
        }
        this.dumpLazyCustomDataMap(customInfo, this.mInstanceLazyCustomParameters, throwable);
        return customInfo.toString();
    }

    private void dumpLazyCustomDataMap(StringBuilder sb, Map<String, CustomReportDataSupplier> params, Throwable throwable) {
        for (Map.Entry<String, CustomReportDataSupplier> entry : params.entrySet()) {
            String value;
            String key = entry.getKey();
            try {
                value = entry.getValue().getCustomData(throwable);
            }
            catch (Throwable th) {
                Log.e((String)"CrashReporting", (String)"Caught throwable while getting custom report data", (Throwable)th);
                continue;
            }
            if (value == null) continue;
            this.dumpCustomDataEntry(sb, key, value);
        }
    }

    private void dumpCustomDataMap(StringBuilder sb, Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.dumpCustomDataEntry(sb, key, value);
        }
    }

    private void dumpCustomDataEntry(StringBuilder sb, String key, String value) {
        key = key != null ? key.replace("\n", "\\n") : null;
        value = value != null ? value.replace("\n", "\\n") : null;
        sb.append(key).append(" = ").append(value).append("\n");
    }

    private String getProcessNameFromAmsOrNull() {
        if (this.processNameByAmsReady) {
            return this.processNameByAms;
        }
        this.processNameByAms = null;
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        if (am == null) {
            return this.processNameByAms;
        }
        List processes = am.getRunningAppProcesses();
        if (processes == null) {
            return this.processNameByAms;
        }
        for (ActivityManager.RunningAppProcessInfo rai : processes) {
            if (rai.pid != pid) continue;
            this.processNameByAms = rai.processName;
            break;
        }
        this.processNameByAmsReady = true;
        return this.processNameByAms;
    }

    private void resetProcessNameByAmsCache() {
        this.processNameByAms = null;
        this.processNameByAmsReady = false;
    }

    private String getProcessNameFromAms() {
        String processName = this.getProcessNameFromAmsOrNull();
        if (processName == null) {
            processName = "n/a";
        }
        return processName;
    }

    private String getProcessName() {
        String processName = this.getProcessNameFromAmsOrNull();
        if (processName == null) {
            BufferedReader bufferedReader = null;
            try {
                FileReader reader = new FileReader("/proc/self/cmdline");
                bufferedReader = new BufferedReader(reader, 128);
                processName = bufferedReader.readLine();
                if (processName != null) {
                    processName = processName.trim();
                }
            }
            catch (IOException ex) {
                Log.e((String)"CrashReporting", (String)"Failed to get process name.", (Throwable)ex);
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    Log.e((String)"CrashReporting", (String)"Failed to close file.", (Throwable)ex);
                }
            }
        }
        if (processName == null) {
            processName = "";
        }
        return processName;
    }

    private String getJailStatus() {
        String buildTags = Build.TAGS;
        if (buildTags != null && buildTags.contains("test-keys")) {
            return "yes";
        }
        try {
            File file = new File("/system/app/Superuser.apk");
            if (file.exists()) {
                return "yes";
            }
        }
        catch (Exception ex) {
            Log.e((String)"CrashReporting", (String)"Failed to find Superuser.pak", (Throwable)ex);
        }
        Map<String, String> env = System.getenv();
        if (env != null) {
            String[] dirs;
            String path = env.get("PATH");
            for (String dir : dirs = path.split(":")) {
                String suPath = dir + "/" + "su";
                try {
                    File suFile = new File(suPath);
                    if (suFile != null && suFile.exists()) {
                        return "yes";
                    }
                }
                catch (Exception ex) {
                    Log.e((String)"CrashReporting", (String)"Failed to find su binary in the PATH", (Throwable)ex);
                }
            }
        }
        return "no";
    }

    private long getProcessUptime() {
        return Process.getElapsedCpuTime();
    }

    private long getDeviceUptime() {
        return SystemClock.elapsedRealtime();
    }

    public static ErrorReporter getInstance() {
        if (mInstanceSingleton == null) {
            mInstanceSingleton = new ErrorReporter();
        }
        return mInstanceSingleton;
    }

    public void init(Context context, boolean isInternalBuild, FileProvider fileProvider) {
        if (this.mDfltExceptionHandler == null) {
            this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            this.mIsInternalBuild = isInternalBuild;
            this.mContext = context;
            this.mFileProvider = fileProvider;
            PackageManagerWrapper pm = new PackageManagerWrapper(context);
            PackageInfo pi = pm.getPackageInfo();
            if (pi != null) {
                this.mAppVersionCode = Integer.toString(pi.versionCode);
                this.mAppVersionName = pi.versionName != null ? pi.versionName : "not set";
            }
            this.mPackageManager = new PackageManagerWrapper(context);
            String osVersion = System.getProperty("os.version");
            boolean isCyanogenmod = osVersion != null ? osVersion.contains("cyanogenmod") : false;
            this.mAppStartDate.setToNow();
            try {
                this.mConstantFields.put(ReportField.ANDROID_ID, Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
                this.mConstantFields.put(ReportField.APP_VERSION_CODE, this.mAppVersionCode);
                this.mConstantFields.put(ReportField.APP_VERSION_NAME, this.mAppVersionName);
                this.mConstantFields.put(ReportField.PACKAGE_NAME, context.getPackageName());
                this.mConstantFields.put(ReportField.PHONE_MODEL, Build.MODEL);
                this.mConstantFields.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
                this.mConstantFields.put(ReportField.OS_VERSION, osVersion);
                this.mConstantFields.put(ReportField.IS_CYANOGENMOD, Boolean.toString(isCyanogenmod));
                this.mConstantFields.put(ReportField.BRAND, Build.BRAND);
                this.mConstantFields.put(ReportField.PRODUCT, Build.PRODUCT);
                String absolutePath = "n/a";
                File filesDir = context.getFilesDir();
                if (filesDir != null) {
                    absolutePath = filesDir.getAbsolutePath();
                }
                this.mConstantFields.put(ReportField.FILE_PATH, absolutePath);
                if (Build.VERSION.SDK_INT >= 9) {
                    this.mConstantFields.put(ReportField.SERIAL, Build.SERIAL);
                    if (pi != null) {
                        this.mConstantFields.put(ReportField.APP_INSTALL_TIME, this.formatTimestamp(pi.firstInstallTime));
                        this.mConstantFields.put(ReportField.APP_UPGRADE_TIME, this.formatTimestamp(pi.lastUpdateTime));
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"CrashReporting", (String)"failed to install constants", (Throwable)e);
            }
            this.preallocFile = ErrorReporter.fileForName(this.mFileProvider, ACRA_DIRNAME, PREALLOCATED_REPORTFILE);
            this.createPreallocatedReportFile();
        }
    }

    private String formatTimestamp(long time) {
        Time t = new Time();
        t.set(time);
        return t.format3339(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPreallocatedReportFile() {
        FileOutputStream fos = null;
        try {
            if (!this.preallocFile.exists()) {
                byte[] buf = new byte[10240];
                fos = new FileOutputStream(this.preallocFile);
                int i = 0;
                while ((long)i < 51200L) {
                    fos.write(buf);
                    i += buf.length;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"CrashReporting", (String)"Failed to pre-allocate crash report file", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static long getAvailableInternalMemorySize() {
        try {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getAvailableBlocks();
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static long getTotalInternalMemorySize() {
        try {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private void populateConstantDeviceData(CrashReportData crashReport, Writer writer) {
        Map<ReportField, String> deviceData = this.getConstantDeviceData();
        for (Map.Entry<ReportField, String> entry : deviceData.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), crashReport, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ReportField, String> getConstantDeviceData() {
        Map<ReportField, String> map = this.mDeviceSpecificFields;
        synchronized (map) {
            if (this.mDeviceSpecificFields.isEmpty()) {
                TelephonyManager tm;
                String deviceId;
                this.mDeviceSpecificFields.put(ReportField.BUILD, ReflectionCollector.collectConstants(Build.class));
                this.mDeviceSpecificFields.put(ReportField.JAIL_BROKEN, this.getJailStatus());
                this.mDeviceSpecificFields.put(ReportField.INSTALLATION_ID, Installation.id(this.mFileProvider));
                this.mDeviceSpecificFields.put(ReportField.TOTAL_MEM_SIZE, Long.toString(ErrorReporter.getTotalInternalMemorySize()));
                if (this.mPackageManager.hasPermission("android.permission.READ_PHONE_STATE") && (deviceId = (tm = (TelephonyManager)this.mContext.getSystemService("phone")).getDeviceId()) != null) {
                    this.mDeviceSpecificFields.put(ReportField.DEVICE_ID, deviceId);
                }
                Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
                this.mDeviceSpecificFields.put(ReportField.DISPLAY, ErrorReporter.toString(display));
                this.mDeviceSpecificFields.put(ReportField.ENVIRONMENT, ReflectionCollector.collectStaticGettersResults(Environment.class));
                this.mDeviceSpecificFields.put(ReportField.DEVICE_FEATURES, DeviceFeaturesCollector.getFeatures(this.mContext));
                this.mDeviceSpecificFields.put(ReportField.SETTINGS_SYSTEM, SettingsCollector.collectSystemSettings(this.mContext));
                this.mDeviceSpecificFields.put(ReportField.SETTINGS_SECURE, SettingsCollector.collectSecureSettings(this.mContext));
                if (Build.VERSION.SDK_INT >= 19) {
                    ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
                    this.mDeviceSpecificFields.put(ReportField.IS_LOW_RAM_DEVICE, Boolean.toString(am.isLowRamDevice()));
                }
                this.mDeviceSpecificFields.put(ReportField.ANDROID_RUNTIME, this.getAndroidRuntime());
            }
            return this.mDeviceSpecificFields;
        }
    }

    private String getAndroidRuntime() {
        if (Build.VERSION.SDK_INT < 19) {
            return ANDROID_RUNTIME_DALVIK;
        }
        String bootClassPath = System.getProperty(JAVA_BOOT_CLASS_PATH);
        if (bootClassPath != null) {
            if (bootClassPath.contains(KNOWN_ART_JAR)) {
                return ANDROID_RUNTIME_ART;
            }
            if (bootClassPath.contains(KNOWN_DALVIK_JAR)) {
                return ANDROID_RUNTIME_DALVIK;
            }
        }
        return ANDROID_RUNTIME_UNKNOWN;
    }

    private void retrieveCrashTimeData(Context context, Throwable e, ReportField[] fields, CrashReportData crashReport, Writer writer) throws Exception {
        ProcFileReader.OpenFDLimits limits;
        List<ReportField> fieldsList = Arrays.asList(fields);
        if (fieldsList.contains((Object)ReportField.REPORT_ID)) {
            this.put(ReportField.REPORT_ID, UUID.randomUUID().toString(), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.PROCESS_NAME)) {
            this.put(ReportField.PROCESS_NAME, this.getProcessName(), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.USER_APP_START_DATE)) {
            this.put(ReportField.USER_APP_START_DATE, this.mAppStartDate.format3339(false), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.PROCESS_UPTIME)) {
            this.put(ReportField.PROCESS_UPTIME, Long.toString(this.getProcessUptime()), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.DEVICE_UPTIME)) {
            this.put(ReportField.DEVICE_UPTIME, Long.toString(this.getDeviceUptime()), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.CRASH_CONFIGURATION)) {
            Configuration crashConf = context.getResources().getConfiguration();
            this.put(ReportField.CRASH_CONFIGURATION, ConfigurationInspector.toString(crashConf), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.AVAILABLE_MEM_SIZE)) {
            String internalMemorySize = Long.toString(ErrorReporter.getAvailableInternalMemorySize());
            this.put(ReportField.AVAILABLE_MEM_SIZE, internalMemorySize, crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.DUMPSYS_MEMINFO)) {
            this.put(ReportField.DUMPSYS_MEMINFO, DumpSysCollector.collectMemInfo(context), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.USER_CRASH_DATE)) {
            Time curDate = new Time();
            curDate.setToNow();
            this.put(ReportField.USER_CRASH_DATE, curDate.format3339(false), crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.ACTIVITY_LOG)) {
            String activityLogDump = e instanceof OutOfMemoryError ? this.activityLogger.toString() : this.activityLogger.toString(DEFAULT_TRACE_COUNT_LIMIT);
            this.put(ReportField.ACTIVITY_LOG, activityLogDump, crashReport, writer);
        }
        if (fieldsList.contains((Object)ReportField.PROCESS_NAME_BY_AMS)) {
            this.put(ReportField.PROCESS_NAME_BY_AMS, this.getProcessNameFromAms(), crashReport, writer);
        }
        this.resetProcessNameByAmsCache();
        if (fieldsList.contains((Object)ReportField.OPEN_FD_COUNT)) {
            this.put(ReportField.OPEN_FD_COUNT, String.valueOf(ProcFileReader.getOpenFDCount()), crashReport, writer);
        }
        if ((fieldsList.contains((Object)ReportField.OPEN_FD_SOFT_LIMIT) || fieldsList.contains((Object)ReportField.OPEN_FD_HARD_LIMIT)) && (limits = ProcFileReader.getOpenFDLimits()) != null) {
            if (fieldsList.contains((Object)ReportField.OPEN_FD_SOFT_LIMIT)) {
                this.put(ReportField.OPEN_FD_SOFT_LIMIT, limits.softLimit, crashReport, writer);
            }
            if (fieldsList.contains((Object)ReportField.OPEN_FD_HARD_LIMIT)) {
                this.put(ReportField.OPEN_FD_HARD_LIMIT, limits.hardLimit, crashReport, writer);
            }
        }
        if (Build.VERSION.SDK_INT >= 16 && this.mIsInternalBuild) {
            if (fieldsList.contains((Object)ReportField.LOGCAT)) {
                this.put(ReportField.LOGCAT, LogCatCollector.collectLogCat(null), crashReport, writer);
            }
            if (fieldsList.contains((Object)ReportField.EVENTSLOG)) {
                this.put(ReportField.EVENTSLOG, LogCatCollector.collectLogCat("events"), crashReport, writer);
            }
            if (fieldsList.contains((Object)ReportField.RADIOLOG)) {
                this.put(ReportField.RADIOLOG, LogCatCollector.collectLogCat("radio"), crashReport, writer);
            }
            if (fieldsList.contains((Object)ReportField.DROPBOX)) {
                String dropBoxDump = DropBoxCollector.read(this.mContext, ACRA.getConfig().additionalDropBoxTags());
                this.put(ReportField.DROPBOX, dropBoxDump, crashReport, writer);
            }
        }
        if (fieldsList.contains((Object)ReportField.LARGE_MEM_HEAP) && Build.VERSION.SDK_INT >= 11) {
            this.put(ReportField.LARGE_MEM_HEAP, DumpSysCollector.collectLargerMemoryInfo(context), crashReport, writer);
        }
    }

    private static String toString(Display display) {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        StringBuilder result = new StringBuilder();
        result.append("width=").append(display.getWidth()).append('\n').append("height=").append(display.getHeight()).append('\n').append("pixelFormat=").append(display.getPixelFormat()).append('\n').append("refreshRate=").append(display.getRefreshRate()).append("fps").append('\n').append("metrics.density=x").append(metrics.density).append('\n').append("metrics.scaledDensity=x").append(metrics.scaledDensity).append('\n').append("metrics.widthPixels=").append(metrics.widthPixels).append('\n').append("metrics.heightPixels=").append(metrics.heightPixels).append('\n').append("metrics.xdpi=").append(metrics.xdpi).append('\n').append("metrics.ydpi=").append(metrics.ydpi);
        return result.toString();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Log.e((String)"CrashReporting", (String)("ParseCrashReporting caught a " + e.getClass().getSimpleName() + " exception for " + this.mContext.getPackageName() + ". Building report."));
        this.usePreallocatedFile = true;
        boolean wasProcessingCrash = mProcessingCrash.getAndSet(true);
        HashMap<String, String> extra = null;
        try {
            extra = new HashMap<String, String>();
            extra.put(IS_PROCESSING_ANOTHER_EXCEPTION, String.valueOf(wasProcessingCrash));
        }
        catch (OutOfMemoryError ex) {
            // empty catch block
        }
        ReportsSenderWorker worker = this.handleException(e, extra);
        if (worker != null) {
            while (worker.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Log.e((String)"CrashReporting", (String)"Error : ", (Throwable)e1);
                }
            }
            Throwable workerException = worker.getException();
            if (workerException != null) {
                Log.e((String)"CrashReporting", (String)"ReportsWorkerSender failed with exception", (Throwable)workerException);
                ReportField[] fields = this.getReportFieldsForException(e);
                this.handleExceptionInternal(workerException, extra, null, fields, false);
            }
        }
        if (this.mDfltExceptionHandler != null) {
            this.mDfltExceptionHandler.uncaughtException(t, e);
        }
    }

    private void writeToLogBridge(String tag, String message, Throwable t, String overrideStackTrace) {
        LogBridge logBridge = this.getLogBridge();
        if (logBridge != null) {
            if (overrideStackTrace != null) {
                logBridge.log(tag, message + "\n" + overrideStackTrace, null);
            } else {
                logBridge.log(tag, message, t);
            }
        } else if (overrideStackTrace != null) {
            Log.e((String)tag, (String)(message + "\n" + overrideStackTrace));
        } else {
            Log.e((String)tag, (String)message, (Throwable)t);
        }
    }

    private String throwableToString(Throwable e) {
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        printWriter.close();
        return ((Object)result).toString();
    }

    private void gatherCrashData(String stackTrace, Throwable e, ReportField[] fields, CrashReportData crashReport, Writer w, Map<String, String> extras) throws Exception {
        if (fields == null) {
            fields = ACRA.MINIMAL_REPORT_FIELDS;
        }
        this.put(ReportField.UID, this.getUserId(), crashReport, w);
        this.put(ReportField.STACK_TRACE, stackTrace, crashReport, w);
        for (Map.Entry<ReportField, String> entry : this.mConstantFields.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), crashReport, w);
        }
        this.retrieveCrashTimeData(this.mContext, e, fields, crashReport, w);
        this.populateConstantDeviceData(crashReport, w);
        this.put(ReportField.CUSTOM_DATA, this.dumpCustomDataToString(extras, e), crashReport, w);
    }

    private void put(ReportField key, String value, CrashReportData crashReport, Writer writer) {
        try {
            crashReport.put(key, value, this.sendInMemoryReport ? null : writer);
        }
        catch (IOException ex) {
            this.sendInMemoryReport = true;
        }
    }

    public void writeReportToStream(Throwable e, OutputStream os) throws Exception {
        CrashReportData crashReport = new CrashReportData();
        Writer w = CrashReportData.getWriter(os);
        String stackTrace = this.throwableToString(e);
        this.gatherCrashData(stackTrace, e, ACRA.ALL_CRASH_REPORT_FIELDS, crashReport, w, null);
    }

    public ReportsSenderWorker handleException(Throwable e) {
        return this.handleException(e, null);
    }

    public ReportsSenderWorker handleException(Throwable e, Map<String, String> extras) {
        boolean sendImmediately = !(e instanceof OutOfMemoryError);
        ReportField[] fields = this.getReportFieldsForException(e);
        return this.handleExceptionInternal(e, extras, null, fields, sendImmediately);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportsSenderWorker handleExceptionInternal(Throwable e, Map<String, String> extras, String overrideStackTrace, ReportField[] fields, boolean shouldSendImmediately) {
        Throwable mostSignificantCause = this.getMostSignificantCause(e);
        Class<?> causeClass = mostSignificantCause.getClass();
        if (!this.shouldContinueProcessingException(mostSignificantCause)) {
            return null;
        }
        CrashReportData crashReport = new CrashReportData();
        String description = e instanceof NonCrashException ? ((NonCrashException)((Object)e)).getExceptionFriendlyName() : "crash";
        this.writeToLogBridge("CrashReporting", "Handling exception for " + description, e, overrideStackTrace);
        Log.d((String)"CrashReporting", (String)("Generating report file for " + description));
        String tempReportFileName = this.genCrashReportFileName(causeClass, TEMP_REPORTFILE_EXTENSION);
        File tempReportFile = ErrorReporter.fileForName(this.mFileProvider, ACRA_DIRNAME, tempReportFileName);
        String reportFileName = this.genCrashReportFileName(causeClass, REPORTFILE_EXTENSION);
        File reportFile = ErrorReporter.fileForName(this.mFileProvider, ACRA_DIRNAME, reportFileName);
        RandomAccessFile outputFile = null;
        Writer tempReportWriter = null;
        try {
            if (this.usePreallocatedFile) {
                this.preallocFile.renameTo(tempReportFile);
            }
            outputFile = new RandomAccessFile(tempReportFile, "rw");
            tempReportWriter = CrashReportData.getWriter(new FileOutputStream(outputFile.getFD()));
        }
        catch (Exception ex) {
            Log.e((String)"CrashReporting", (String)"An error occurred while creating the report file ...", (Throwable)ex);
            this.sendInMemoryReport = true;
        }
        try {
            this.put(ReportField.ACRA_REPORT_FILENAME, reportFileName, crashReport, tempReportWriter);
            this.put(ReportField.EXCEPTION_CAUSE, causeClass.getName(), crashReport, tempReportWriter);
            if (overrideStackTrace == null) {
                overrideStackTrace = this.throwableToString(e);
            }
            this.gatherCrashData(overrideStackTrace, e, fields, crashReport, tempReportWriter, extras);
        }
        catch (Exception ex) {
            try {
                Log.e((String)"CrashReporting", (String)"An error occurred while gathering crash data ...", (Throwable)ex);
                this.put(ReportField.ACRA_INTERNAL, this.throwableToString(ex), crashReport, tempReportWriter);
            }
            catch (Exception ex1) {
                Log.e((String)"CrashReporting", (String)"An error occurred while gathering internal crash data ...", (Throwable)ex1);
                this.put(ReportField.ACRA_INTERNAL, mInternalException, crashReport, tempReportWriter);
            }
            finally {
                Log.e((String)"CrashReporting", (String)"An error occurred while gathering crash data ...", (Throwable)ex);
            }
        }
        finally {
            try {
                if (outputFile != null) {
                    FileChannel chan = outputFile.getChannel();
                    chan.truncate(chan.position());
                    outputFile.close();
                    tempReportFile.renameTo(reportFile);
                }
            }
            catch (Exception ex) {
                Log.e((String)"CrashReporting", (String)"An error occurred while deleting closing the report file ...", (Throwable)ex);
            }
        }
        if (shouldSendImmediately) {
            ReportsSenderWorker wk = this.sendInMemoryReport ? new ReportsSenderWorker(crashReport) : new ReportsSenderWorker(CrashReportType.ACRA_CRASH_REPORT);
            Log.v((String)"CrashReporting", (String)"About to start ReportSenderWorker from #handleException");
            wk.start();
            return wk;
        }
        Log.v((String)"CrashReporting", (String)"ParseCrashReporting caught an OutOfMemoryError. Report upload deferred until next ParseCrashReporting launch.");
        return null;
    }

    public ReportsSenderWorker handleException(Throwable e, String stackTrace, Map<String, String> extras) {
        ReportField[] fields = this.getReportFieldsForException(e);
        return this.handleExceptionInternal(e, extras, stackTrace, fields, true);
    }

    public void handleExceptionWithCustomFields(Exception e, Map<String, String> data, ReportField[] fields) {
        this.handleExceptionInternal(e, data, null, fields, true);
    }

    private void sendCrashReport(CrashReportData errorContent) throws ReportSenderException {
        boolean sentAtLeastOnce = false;
        for (ReportSender sender : this.mReportSenders) {
            try {
                sender.send(errorContent);
                sentAtLeastOnce = true;
            }
            catch (ReportSenderException e) {
                if (!sentAtLeastOnce) {
                    throw e;
                }
                Log.w((String)"CrashReporting", (String)("ReportSender of class " + sender.getClass().getName() + " failed but other senders completed their task. " + "ParseCrashReporting will not send this report again."));
            }
        }
    }

    private String genCrashReportFileName(Class cause, String fileExtension) {
        return Long.toString(System.currentTimeMillis()) + "-" + cause.getSimpleName() + (this.mAppVersionCode != null ? "-" + this.mAppVersionCode : "") + fileExtension;
    }

    public String[] getCrashReportFilesList(String path, final String ... extensions) {
        if (this.mContext == null) {
            Log.e((String)"CrashReporting", (String)"Trying to get crash reports but crash reporting is not initialized.");
            return new String[0];
        }
        File dir = this.mFileProvider.getFile(path);
        if (dir != null) {
            Log.d((String)"CrashReporting", (String)("Looking for error files in " + dir.getAbsolutePath()));
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String extension : extensions) {
                        if (!name.endsWith(extension)) continue;
                        return true;
                    }
                    return false;
                }
            };
            String[] result = dir.list(filter);
            return result == null ? new String[]{} : result;
        }
        Log.w((String)"CrashReporting", (String)"Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
        return new String[0];
    }

    synchronized void checkAndSendReports(Context context, CrashReportType ... types) {
        Log.d((String)"CrashReporting", (String)"#checkAndSendReports - start");
        for (CrashReportType reportType : types) {
            if (CrashReportType.ACRA_CRASH_REPORT == reportType) {
                this.checkAndSendAcraReports(context);
                continue;
            }
            this.checkAndSendCrashAttachments(context, reportType);
        }
        Log.d((String)"CrashReporting", (String)"#checkAndSendReports - finish");
    }

    private void checkAndSendAcraReports(Context context) {
        Object[] reportFiles = this.getCrashReportFilesList(ACRA_DIRNAME, REPORTFILE_EXTENSION, TEMP_REPORTFILE_EXTENSION);
        Arrays.sort(reportFiles);
        int reportsSentCount = 0;
        String uploadedByProcess = this.getProcessNameFromAms();
        for (Object curFileName : reportFiles) {
            block6: {
                if (reportsSentCount >= 5) {
                    this.deleteFile(ACRA_DIRNAME, (String)curFileName);
                    continue;
                }
                Log.d((String)"CrashReporting", (String)("Loading file " + (String)curFileName));
                try {
                    CrashReportData previousCrashReport = this.loadAcraCrashReport(context, (String)curFileName);
                    if (previousCrashReport == null) break block6;
                    previousCrashReport.put(ReportField.ACRA_REPORT_FILENAME, curFileName);
                    previousCrashReport.put(ReportField.UPLOADED_BY_PROCESS, uploadedByProcess);
                    Log.i((String)"CrashReporting", (String)("Sending file " + (String)curFileName));
                    this.sendCrashReport(previousCrashReport);
                    this.deleteFile(ACRA_DIRNAME, (String)curFileName);
                }
                catch (RuntimeException e) {
                    Log.e((String)"CrashReporting", (String)"Failed to send crash reports", (Throwable)e);
                    this.deleteFile(ACRA_DIRNAME, (String)curFileName);
                    break;
                }
                catch (IOException e) {
                    Log.e((String)"CrashReporting", (String)("Failed to load crash report for " + (String)curFileName), (Throwable)e);
                    this.deleteFile(ACRA_DIRNAME, (String)curFileName);
                    break;
                }
                catch (ReportSenderException e) {
                    Log.e((String)"CrashReporting", (String)("Failed to send crash report for " + (String)curFileName), (Throwable)e);
                    break;
                }
            }
            ++reportsSentCount;
        }
    }

    private int checkAndSendCrashAttachments(Context context, CrashReportType type) {
        Log.d((String)"CrashReporting", (String)"#checkAndSendCrashAttachments - start");
        int dumpsSend = 0;
        Object[] dumpFiles = this.getCrashReportFilesList(type.directory, type.fileExtensions);
        if (dumpFiles != null && dumpFiles.length > 0) {
            Arrays.sort(dumpFiles);
            CrashReportData tempCrashReportData = new CrashReportData();
            try {
                this.gatherCrashData(CRASH_ATTACHMENT_DUMMY_STACKTRACE, new CrashAttachmentException(), ACRA.ALL_CRASH_REPORT_FIELDS, tempCrashReportData, null, null);
            }
            catch (Exception e) {
                String message = "retrieve exception: " + e.getMessage();
                this.put(ReportField.REPORT_LOAD_THROW, message, tempCrashReportData, null);
            }
            for (Object fname : dumpFiles) {
                if (dumpsSend >= 5) {
                    this.deleteFile(DUMP_DIR, (String)fname);
                    continue;
                }
                try {
                    CrashReportData reportData = this.loadCrashAttachment(context, (String)fname, type);
                    String attachment = "load failed";
                    if (reportData != null) {
                        attachment = (String)reportData.get((Object)type.attachmentField);
                    }
                    tempCrashReportData.put(ReportField.REPORT_ID, ((String)fname).substring(0, ((String)fname).lastIndexOf(46)), null);
                    tempCrashReportData.put(type.attachmentField, attachment, null);
                    tempCrashReportData.put(ReportField.EXCEPTION_CAUSE, CRASH_ATTACHMENT_DUMMY_STACKTRACE, null);
                    this.sendCrashReport(tempCrashReportData);
                    this.deleteFile(type.directory, (String)fname);
                    ++dumpsSend;
                }
                catch (ReportSenderException e) {
                    Log.e((String)"CrashReporting", (String)("Failed to send crash attachment report " + (String)fname), (Throwable)e);
                    break;
                }
                catch (Throwable e) {
                    Log.e((String)"CrashReporting", (String)("Failed on crash attachment file " + (String)fname), (Throwable)e);
                    this.deleteFile(type.directory, (String)fname);
                    break;
                }
            }
        }
        Log.d((String)"CrashReporting", (String)("#checkAndSendCrashAttachments - finish, sent: " + Integer.toString(dumpsSend)));
        return dumpsSend;
    }

    synchronized void sendInMemoryReport(Context context, CrashReportData crashReport) {
        Log.i((String)"CrashReporting", (String)"Sending in-memory report");
        try {
            File reportFile;
            String uploadedByProcess = this.getProcessNameFromAms();
            crashReport.put(ReportField.UPLOADED_BY_PROCESS, uploadedByProcess);
            this.sendCrashReport(crashReport);
            String reportName = (String)crashReport.get((Object)ReportField.ACRA_REPORT_FILENAME);
            if (reportName != null && (reportFile = ErrorReporter.fileForName(this.mFileProvider, ACRA_DIRNAME, reportName)) != null) {
                reportFile.delete();
            }
        }
        catch (Exception e) {
            Log.e((String)"CrashReporting", (String)"Failed to send in-memory crash report: ", (Throwable)e);
        }
    }

    private CrashReportData loadAcraCrashReport(Context context, String fileName) throws IOException {
        return this.loadCrashReport(context, fileName, CrashReportType.ACRA_CRASH_REPORT, this.mMaxReportSize);
    }

    private CrashReportData loadCrashAttachment(Context context, String fileName, CrashReportType type) throws IOException {
        return this.loadCrashReport(context, fileName, type, type.defaultMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrashReportData loadCrashReport(Context context, String fileName, CrashReportType crashReportType, long maxSize) throws IOException {
        CrashReportData crashReport = new CrashReportData();
        File rptfp = ErrorReporter.fileForName(this.mFileProvider, crashReportType.directory, fileName);
        if (System.currentTimeMillis() - rptfp.lastModified() > 86400000L) {
            Log.w((String)"CrashReporting", (String)("crash report " + fileName + " was too old; deleted"));
            this.deleteFile(crashReportType.directory, fileName);
            return null;
        }
        if (fileName.endsWith(TEMP_REPORTFILE_EXTENSION) && System.currentTimeMillis() - rptfp.lastModified() < 600000L) {
            Log.w((String)"CrashReporting", (String)("temp file " + fileName + " is too recent; skipping"));
            return null;
        }
        if (rptfp.length() > maxSize) {
            Log.w((String)"CrashReporting", (String)("" + rptfp.length() + "-byte crash report " + fileName + " exceeded max size of " + maxSize + " bytes; deleted"));
            this.deleteFile(crashReportType.directory, fileName);
            return null;
        }
        FileInputStream input = new FileInputStream(rptfp);
        boolean closed = false;
        try {
            if (crashReportType == CrashReportType.ACRA_CRASH_REPORT) {
                crashReport.load(input);
            } else {
                int nbytes = (int)rptfp.length();
                String attachment = this.loadAttachment(input, nbytes);
                crashReport.put(crashReportType.attachmentField, attachment);
            }
        }
        catch (Throwable th) {
            crashReport.put(ReportField.REPORT_LOAD_THROW, "throwable: " + th.getMessage());
            Log.e((String)"CrashReporting", (String)("Could not load crash report:" + fileName + " " + th));
            input.close();
            closed = true;
            context.deleteFile(fileName);
            Log.e((String)"CrashReporting", (String)("Crash report:" + fileName + " deleted"));
        }
        finally {
            if (!closed) {
                input.close();
            }
        }
        crashReport.put(ReportField.ACRA_REPORT_FILENAME, fileName);
        this.backfillCrashReportData(crashReport);
        return crashReport;
    }

    void backfillCrashReportData(CrashReportData crashReport) {
        String versionCode = this.parseVersionCodeFromFileName(crashReport.getProperty(ReportField.ACRA_REPORT_FILENAME));
        boolean hasAppBeenUpgraded = !versionCode.equals(this.mAppVersionCode);
        String reportID = (String)crashReport.get((Object)ReportField.REPORT_ID);
        if (reportID == null || reportID.length() == 0) {
            for (Map.Entry<ReportField, String> e : this.mConstantFields.entrySet()) {
                if (e.getKey().equals((Object)ReportField.APP_VERSION_NAME)) {
                    if (hasAppBeenUpgraded) continue;
                    crashReport.put((Enum)e.getKey(), e.getValue());
                    continue;
                }
                if (crashReport.get((Object)e.getKey()) != null) continue;
                crashReport.put((Enum)e.getKey(), e.getValue());
            }
        }
        String currentUserId = this.getUserId();
        String previousUid = (String)crashReport.get((Object)ReportField.UID);
        if (!TextUtils.isEmpty((CharSequence)currentUserId) && TextUtils.isEmpty((CharSequence)previousUid)) {
            crashReport.put(ReportField.UID, currentUserId);
        }
    }

    public String parseVersionCodeFromFileName(String fileName) {
        Matcher matcher;
        if (fileName != null && (matcher = VERSION_CODE_REGEX.matcher(fileName)).matches()) {
            return matcher.group(1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAttachment(InputStream in, int nbytes) throws IOException {
        int offset = 0;
        int nbytesread = 0;
        byte[] attachment = new byte[nbytes];
        while (nbytes - offset > 0 && (nbytesread = in.read(attachment, offset, nbytes - offset)) != -1) {
            offset += nbytesread;
        }
        if (nbytesread == 0) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = null;){
            gzipOutputStream = new GZIPOutputStream(baos);
            gzipOutputStream.write(attachment, 0, attachment.length);
            gzipOutputStream.finish();
            String string = Base64.encodeToString((byte[])baos.toByteArray(), (int)0);
            return string;
        }
    }

    private static File fileForName(FileProvider fileProvider, String path, String fileName) {
        File cdir = fileProvider.getFile(path);
        return new File(cdir, fileName);
    }

    private void deleteFile(String path, String fileName) {
        boolean deleted = ErrorReporter.fileForName(this.mFileProvider, path, fileName).delete();
        if (!deleted) {
            Log.w((String)"CrashReporting", (String)("Could not delete error report : " + fileName));
        }
    }

    public ReportsSenderWorker checkReportsOnApplicationStart() {
        String[] filesList = this.getCrashReportFilesList(ACRA_DIRNAME, REPORTFILE_EXTENSION);
        String[] nativeCrashFileList = this.getCrashReportFilesList(DUMP_DIR, DUMPFILE_EXTENSION);
        if (filesList != null && filesList.length > 0 || nativeCrashFileList != null && nativeCrashFileList.length > 0) {
            Log.v((String)"CrashReporting", (String)"About to start ReportSenderWorker from #checkReportOnApplicationStart");
            if (nativeCrashFileList != null && nativeCrashFileList.length > 0) {
                this.mHasNativeCrashDumpOnInit = true;
            }
            return this.checkReportsOfType(ALL_REPORT_TYPES);
        }
        return null;
    }

    public ReportsSenderWorker checkReportsOfType(CrashReportType ... types) {
        ReportsSenderWorker worker = new ReportsSenderWorker(types);
        worker.start();
        return worker;
    }

    public boolean isNativeCrashedOnPreviousRun() {
        return this.mHasNativeCrashDumpOnInit;
    }

    public void addReportSender(ReportSender sender) {
        this.mReportSenders.add(sender);
    }

    public void removeAllReportSenders() {
        this.mReportSenders.clear();
    }

    public void setMaxReportSize(long size) {
        this.mMaxReportSize = size;
    }

    public void setReportSender(ReportSender sender) {
        this.removeAllReportSenders();
        this.addReportSender(sender);
    }

    public void registerActivity(String activityName) {
        if (activityName != null) {
            this.activityLogger.append(activityName);
        }
    }

    private ReportField[] getReportFieldsForException(Throwable e) {
        return e instanceof OutOfMemoryError ? ACRA.MINIMAL_REPORT_FIELDS : ACRA.ALL_CRASH_REPORT_FIELDS;
    }

    Throwable getMostSignificantCause(Throwable e) {
        if (e instanceof NonCrashException) {
            return e;
        }
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldContinueProcessingException(Throwable t) {
        Object object = this.mShouldContinueProcessingExceptionLock;
        synchronized (object) {
            if (this.mCurrentlyProcessingOOM) {
                return false;
            }
            if (t instanceof OutOfMemoryError) {
                this.mCurrentlyProcessingOOM = true;
            }
            return true;
        }
    }

    static {
        DEFAULT_TRACE_COUNT_LIMIT = 5;
        MAX_TRACE_COUNT_LIMIT = 20;
        mProcessingCrash = new AtomicBoolean(false);
    }

    private class CrashAttachmentException
    extends Throwable {
        private CrashAttachmentException() {
        }
    }

    final class ReportsSenderWorker
    extends Thread {
        private Throwable exception = null;
        private CrashReportData mInMemoryReportToSend;
        private final CrashReportType[] mReportTypesToSend;

        public ReportsSenderWorker(CrashReportData inMemoryReportToSend) {
            this(new CrashReportType[0]);
            this.mInMemoryReportToSend = inMemoryReportToSend;
        }

        public ReportsSenderWorker(CrashReportType ... reportTypesToSend) {
            this.mReportTypesToSend = reportTypesToSend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PowerManager.WakeLock wakeLock = null;
            try {
                wakeLock = this.acquireWakeLock();
                if (this.mInMemoryReportToSend != null) {
                    ErrorReporter.this.sendInMemoryReport(ErrorReporter.this.mContext, this.mInMemoryReportToSend);
                } else {
                    ErrorReporter.this.checkAndSendReports(ErrorReporter.this.mContext, this.mReportTypesToSend);
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        private PowerManager.WakeLock acquireWakeLock() {
            PackageManagerWrapper pm = new PackageManagerWrapper(ErrorReporter.this.mContext);
            if (!pm.hasPermission("android.permission.WAKE_LOCK")) {
                return null;
            }
            PowerManager powerManager = (PowerManager)ErrorReporter.this.mContext.getSystemService("power");
            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "crash reporting wakelock");
            wakeLock.setReferenceCounted(false);
            wakeLock.acquire();
            return wakeLock;
        }
    }

    public static enum CrashReportType {
        ACRA_CRASH_REPORT("cr/reports", 51200L, null, ".stacktrace", ".temp_stacktrace"),
        NATIVE_CRASH_REPORT("cr/minidumps", 512000L, ReportField.MINIDUMP, ".dmp"),
        ANR_REPORT("traces", 122880L, ReportField.SIGQUIT, ".stacktrace", ".temp_stacktrace");

        private final String directory;
        private final long defaultMaxSize;
        private final ReportField attachmentField;
        private final String[] fileExtensions;

        private CrashReportType(String directory, long maxSize, ReportField attachmentField, String ... fileExtensions) {
            this.directory = directory;
            this.defaultMaxSize = maxSize;
            this.attachmentField = attachmentField;
            this.fileExtensions = fileExtensions;
        }
    }
}

