/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import java.util.Locale;

class DumpSysCollector {
    DumpSysCollector() {
    }

    protected static String collectMemInfo(Context context) {
        StringBuilder meminfo = new StringBuilder();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        Debug.MemoryInfo dmi = new Debug.MemoryInfo();
        Debug.getMemoryInfo((Debug.MemoryInfo)dmi);
        int memclass = am.getMemoryClass();
        int pct_dn = (int)(100.0f * ((float)(dmi.nativePrivateDirty + dmi.dalvikPrivateDirty) / (1024.0f * (float)memclass)));
        int pct_n = (int)((float)(100 * dmi.nativePrivateDirty) / (1024.0f * (float)memclass));
        int pct_dno = (int)((float)(100 * (dmi.nativePrivateDirty + dmi.dalvikPrivateDirty + dmi.otherPrivateDirty)) / (1024.0f * (float)memclass));
        int pct_o = (int)((float)(100 * dmi.otherPrivateDirty) / (1024.0f * (float)memclass));
        meminfo.append(String.format(Locale.US, "percent dalvik+native / native / d+n+other / other %d / %d / %d / %d", pct_dn, pct_n, pct_dno, pct_o));
        meminfo.append("avail/thresh/low? " + mi.availMem + "/" + mi.threshold + "/" + mi.lowMemory + "/" + "(" + (int)((float)(100L * mi.threshold) / (float)mi.availMem) + "%) memclass=" + memclass);
        meminfo.append("DebugMemInfo(kB): Private / Proportional / Shared");
        meminfo.append(String.format(Locale.US, "          dalvik: %7d / %7d / %7d", dmi.dalvikPrivateDirty, dmi.dalvikPss, dmi.dalvikSharedDirty));
        meminfo.append(String.format(Locale.US, "          native: %7d / %7d / %7d", dmi.dalvikPrivateDirty, dmi.nativePss, dmi.nativeSharedDirty));
        meminfo.append(String.format(Locale.US, "           other: %7d / %7d / %7d", dmi.otherPrivateDirty, dmi.otherPss, dmi.otherSharedDirty));
        meminfo.append(String.format(Locale.US, "GC: %d GCs, %d freed, %d free count", Debug.getGlobalGcInvocationCount(), Debug.getGlobalFreedSize(), Debug.getGlobalFreedCount()));
        meminfo.append(String.format(Locale.US, "Native Heap: size/allocated/free %7d / %7d / %7d", Debug.getNativeHeapSize(), Debug.getNativeHeapAllocatedSize(), Debug.getNativeHeapFreeSize()));
        meminfo.append(String.format(Locale.US, "Threads: alloc count/alloc size/ext ac/ext as %7d / %7d / %7d / %7d", Debug.getThreadAllocCount(), Debug.getThreadAllocSize(), Debug.getThreadExternalAllocCount(), Debug.getThreadExternalAllocSize()));
        Runtime runtime = Runtime.getRuntime();
        meminfo.append(String.format(Locale.US, "Java Heap: size/allocated/free %7d / %7d / %7d", runtime.maxMemory(), runtime.totalMemory() - runtime.freeMemory(), runtime.freeMemory()));
        return meminfo.toString();
    }

    protected static String collectLargerMemoryInfo(Context context) {
        if (Build.VERSION.SDK_INT >= 11) {
            StringBuilder writer = new StringBuilder();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            writer.append("Large heap size =" + am.getLargeMemoryClass());
            return writer.toString();
        }
        return "";
    }
}

