/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ACRA;
import com.parse.HttpConnectionProvider;
import com.parse.TrustEveryoneTrustManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class UnsafeConnectionProvider
implements HttpConnectionProvider {
    UnsafeConnectionProvider() {
    }

    @Override
    public HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                TrustManager[] manager = new TrustManager[]{new TrustEveryoneTrustManager()};
                ctx.init(null, manager, null);
                SSLSocketFactory trustEveryoneSocketFactory = ctx.getSocketFactory();
                HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
                httpsConnection.setSSLSocketFactory(trustEveryoneSocketFactory);
                httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
        }
        return this.initializeConnectionParameters(conn);
    }

    public HttpURLConnection initializeConnectionParameters(HttpURLConnection conn) {
        conn.setConnectTimeout(ACRA.getConfig().socketTimeout());
        conn.setReadTimeout(ACRA.getConfig().socketTimeout());
        return conn;
    }
}

