/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ReportField;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;

class CrashReportData
extends EnumMap<ReportField, String> {
    private static final long serialVersionUID = 4112578634029874840L;
    private static final String PROP_DTD_NAME = "http://java.sun.com/dtd/properties.dtd";
    protected CrashReportData defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private static String lineSeparator = "\n";

    public CrashReportData() {
        super(ReportField.class);
    }

    public CrashReportData(CrashReportData properties) {
        super(ReportField.class);
        this.defaults = properties;
    }

    private void dumpString(Appendable sb, String string, boolean key) throws IOException {
        int i = 0;
        int length = string.length();
        if (!key && i < length && string.charAt(i) == ' ') {
            sb.append("\\ ");
            ++i;
        }
        while (i < length) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (key && ch == ' ' || ch == '\\' || ch == '#' || ch == '!' || ch == ':') {
                        sb.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        sb.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    sb.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        sb.append('0');
                    }
                    sb.append(hex);
                }
            }
            ++i;
        }
    }

    public String getProperty(ReportField key) {
        String result = (String)super.get((Object)key);
        if (result == null && this.defaults != null) {
            result = this.defaults.getProperty(key);
        }
        return result;
    }

    public String getProperty(ReportField key, String defaultValue) {
        String property = (String)super.get((Object)key);
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(key);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public void list(PrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        StringBuilder buffer = new StringBuilder(80);
        Enumeration<ReportField> keys = this.keys();
        while (keys.hasMoreElements()) {
            ReportField key = keys.nextElement();
            buffer.append((Object)key);
            buffer.append('=');
            String property = (String)super.get((Object)key);
            CrashReportData def = this.defaults;
            while (property == null) {
                property = (String)def.get((Object)key);
                def = def.defaults;
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            out.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    public void list(PrintWriter writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        StringBuilder buffer = new StringBuilder(80);
        Enumeration<ReportField> keys = this.keys();
        while (keys.hasMoreElements()) {
            ReportField key = keys.nextElement();
            buffer.append((Object)key);
            buffer.append('=');
            String property = (String)super.get((Object)key);
            CrashReportData def = this.defaults;
            while (property == null) {
                property = (String)def.get((Object)key);
                def = def.defaults;
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            writer.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    public synchronized void load(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bis = new BufferedInputStream(in);
        bis.mark(Integer.MAX_VALUE);
        boolean isEbcdic = this.isEbcdic(bis);
        bis.reset();
        if (!isEbcdic) {
            this.load(new InputStreamReader((InputStream)bis, "ISO8859-1"));
        } else {
            this.load(new InputStreamReader(bis));
        }
    }

    private boolean isEbcdic(BufferedInputStream in) throws IOException {
        byte b;
        while ((b = (byte)in.read()) != -1) {
            if (b == 35 || b == 10 || b == 61) {
                return false;
            }
            if (b != 21) continue;
            return true;
        }
        return false;
    }

    public synchronized void load(Reader reader) throws IOException {
        int intVal;
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        BufferedReader br = new BufferedReader(reader);
        block17: while ((intVal = br.read()) != -1 && intVal != 0) {
            int nextChar = intVal;
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else if (count <= 4) {
                    throw new IllegalArgumentException("luni.09");
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10 && nextChar != 133) continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case 13: {
                        mode = 3;
                        continue block17;
                    }
                    case 10: 
                    case 133: {
                        mode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((intVal = br.read()) != -1 && (nextChar = (int)((char)intVal)) != 13 && nextChar != 10 && nextChar != 133) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                    }
                    case 13: 
                    case 133: {
                        mode = 0;
                        firstChar = true;
                        if (offset > 0 || offset == 0 && keyLength == 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            this.put(Enum.valueOf(ReportField.class, temp.substring(0, keyLength)), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        mode = 0;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (mode == 2 && count <= 4) {
            throw new IllegalArgumentException("luni.08");
        }
        if (keyLength == -1 && offset > 0) {
            keyLength = offset;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            ReportField key = Enum.valueOf(ReportField.class, temp.substring(0, keyLength));
            String value = temp.substring(keyLength);
            if (mode == 1) {
                value = value + "\u0000";
            }
            this.put(key, value);
        }
    }

    public String put(ReportField key, String value, Writer writer) throws IOException {
        String result = this.put(key, value);
        if (writer != null) {
            this.storeKeyValuePair(writer, key, value);
        }
        return result;
    }

    private Enumeration<ReportField> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Deprecated
    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(ReportField key, String value) {
        return this.put(key, value);
    }

    public synchronized void store(OutputStream out, String comment) throws IOException {
        this.store(CrashReportData.getWriter(out), comment);
    }

    public static Writer getWriter(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "ISO8859_1");
        }
        catch (UnsupportedEncodingException ux) {
            return null;
        }
    }

    public synchronized void store(Writer writer, String comment) throws IOException {
        if (comment != null) {
            this.storeComment(writer, comment);
        }
        for (Map.Entry entry : this.entrySet()) {
            this.storeKeyValuePair(writer, (ReportField)((Object)entry.getKey()), (String)entry.getValue());
        }
        writer.flush();
    }

    public synchronized void storeComment(Writer writer, String comment) throws IOException {
        writer.write("#");
        writer.write(comment);
        writer.write(lineSeparator);
    }

    public synchronized void storeKeyValuePair(Writer writer, ReportField key, String value) throws IOException {
        String keyString = key.toString();
        String valueString = value == null ? "" : value;
        int totalLength = keyString.length() + valueString.length() + 1;
        StringBuilder sb = new StringBuilder(totalLength + totalLength / 5);
        this.dumpString(sb, keyString, true);
        sb.append('=');
        this.dumpString(sb, valueString, false);
        sb.append(lineSeparator);
        writer.write(sb.toString());
        writer.flush();
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        String encodingCanonicalName;
        if (os == null || encoding == null) {
            throw new NullPointerException();
        }
        try {
            encodingCanonicalName = Charset.forName(encoding).name();
        }
        catch (IllegalCharsetNameException e) {
            System.out.println("Warning: encoding name " + encoding + " is illegal, using UTF-8 as default encoding");
            encodingCanonicalName = "UTF-8";
        }
        catch (UnsupportedCharsetException e) {
            System.out.println("Warning: encoding " + encoding + " is not supported, using UTF-8 as default encoding");
            encodingCanonicalName = "UTF-8";
        }
        PrintStream printStream = new PrintStream(os, false, encodingCanonicalName);
        printStream.print("<?xml version=\"1.0\" encoding=\"");
        printStream.print(encodingCanonicalName);
        printStream.println("\"?>");
        printStream.print("<!DOCTYPE properties SYSTEM \"");
        printStream.print(PROP_DTD_NAME);
        printStream.println("\">");
        printStream.println("<properties>");
        if (comment != null) {
            printStream.print("<comment>");
            printStream.print(this.substitutePredefinedEntries(comment));
            printStream.println("</comment>");
        }
        for (Map.Entry entry : this.entrySet()) {
            String keyValue = ((ReportField)((Object)entry.getKey())).toString();
            String entryValue = (String)entry.getValue();
            printStream.print("<entry key=\"");
            printStream.print(this.substitutePredefinedEntries(keyValue));
            printStream.print("\">");
            printStream.print(this.substitutePredefinedEntries(entryValue));
            printStream.println("</entry>");
        }
        printStream.println("</properties>");
        printStream.flush();
    }

    private String substitutePredefinedEntries(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }
}

