/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import bolts.Continuation;
import bolts.Task;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseAWSRequest;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseFile {
    private boolean dirty = false;
    private String name = null;
    private String url = null;
    private String contentType = null;
    byte[] data;
    private ParseAWSRequest request;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<Task.TaskCompletionSource> currentTasks = Collections.synchronizedSet(new HashSet());

    static File getCacheDir() {
        return Parse.getParseCacheDir("files");
    }

    static File getFilesDir() {
        return Parse.getParseFilesDir("files");
    }

    static void clearCache() {
        for (File file : ParseFile.getCacheDir().listFiles()) {
            ParseFileUtils.deleteQuietly(file);
        }
    }

    public ParseFile(String name, byte[] data, String contentType) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.contentType = contentType;
        this.dirty = true;
    }

    public ParseFile(byte[] data) {
        this(null, data, null);
    }

    public ParseFile(String name, byte[] data) {
        this(name, data, null);
    }

    public ParseFile(byte[] data, String contentType) {
        this(null, data, contentType);
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
    }

    private String getFilename() {
        return this.name;
    }

    File getCacheFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getCacheDir(), filename) : null;
    }

    File getFilesFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getFilesDir(), filename) : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDataAvailable() {
        return this.data != null || (!this.isPinned() ? this.getCacheFile().exists() : this.getFilesFile().exists());
    }

    public String getUrl() {
        return this.url;
    }

    private byte[] getCachedData() {
        File file;
        if (this.data != null) {
            return this.data;
        }
        try {
            file = this.getCacheFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            file = this.getFilesFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    boolean isPinned() {
        File file = this.getFilesFile();
        return file != null && file.exists();
    }

    void pin() throws ParseException {
        this.setPinned(true);
    }

    void unpin() throws ParseException {
        this.setPinned(false);
    }

    Task<Void> pinInBackground() {
        return this.setPinnedInBackground(true);
    }

    Task<Void> unpinInBackground() {
        return this.setPinnedInBackground(false);
    }

    void pinInBackground(ParseCallback<Void> callback) {
        this.setPinnedInBackground(true, callback);
    }

    void unpinInBackground(ParseCallback<Void> callback) {
        this.setPinnedInBackground(false, callback);
    }

    private void setPinned(boolean pinned) throws ParseException {
        Parse.waitForTask(this.setPinnedInBackground(pinned));
    }

    private void setPinnedInBackground(boolean pinned, ParseCallback<Void> callback) {
        Parse.callbackOnMainThreadAsync(this.setPinnedInBackground(pinned), callback);
    }

    private Task<Void> setPinnedInBackground(final boolean pinned) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return task;
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                File dest;
                File src;
                if (pinned && ParseFile.this.isPinned() || !pinned && !ParseFile.this.isPinned()) {
                    return null;
                }
                if (pinned) {
                    src = ParseFile.this.getCacheFile();
                    dest = ParseFile.this.getFilesFile();
                } else {
                    src = ParseFile.this.getFilesFile();
                    dest = ParseFile.this.getCacheFile();
                }
                if (dest == null) {
                    throw new IllegalStateException("Unable to pin file before saving");
                }
                if (dest.exists()) {
                    ParseFileUtils.deleteQuietly(dest);
                }
                if (pinned && ParseFile.this.data != null) {
                    ParseFileUtils.writeByteArrayToFile(dest, ParseFile.this.data);
                    if (src.exists()) {
                        ParseFileUtils.deleteQuietly(src);
                    }
                    return null;
                }
                if (src == null || !src.exists()) {
                    throw new IllegalStateException("Unable to pin file before retrieving");
                }
                ParseFileUtils.moveFile(src, dest);
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private ParseCommand constructFileUploadCommand(String sessionToken) {
        ParseCommand currentCommand = new ParseCommand("upload_file", sessionToken);
        currentCommand.enableRetrying();
        if (this.name != null) {
            currentCommand.put("name", this.name);
        }
        return currentCommand;
    }

    private void prepareFileUploadPost(JSONObject result, ProgressCallback progressCallback) {
        JSONObject postParams;
        String mimeType = null;
        try {
            this.name = result.getString("name");
            this.url = result.getString("url");
            postParams = result.getJSONObject("post_params");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.contentType != null) {
            mimeType = this.contentType;
        } else if (this.name.lastIndexOf(".") != -1) {
            String extension = this.name.substring(this.name.lastIndexOf(".") + 1);
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            String url = result.getString("post_url");
            this.request = new ParseAWSRequest(1, url);
            this.request.setProgressCallback(progressCallback);
            this.request.setMimeType(mimeType);
            this.request.setPostParams(postParams);
            this.request.setData(this.getCachedData());
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Task<Void> handleFileUploadResultAsync(JSONObject result, ProgressCallback progressCallback) {
        if (this.request == null) {
            this.prepareFileUploadPost(result, progressCallback);
        }
        return this.request.executeAsync().makeVoid();
    }

    public void save() throws ParseException {
        Parse.waitForTask(this.saveInBackground());
    }

    private void save(ProgressCallback progressCallback) throws ParseException {
        Parse.waitForTask(this.saveInBackground(progressCallback));
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    tcs.trySetResult(null);
                    return null;
                }
                final String sessionToken = ParseUser.getCurrentSessionToken();
                Task.call((Callable)new Callable<ParseCommand>(){

                    @Override
                    public ParseCommand call() throws Exception {
                        final ParseCommand command = ParseFile.this.constructFileUploadCommand(sessionToken);
                        tcs.getTask().continueWith((Continuation)new Continuation<Void, Void>(){

                            public Void then(Task<Void> task) throws Exception {
                                if (task.isCancelled()) {
                                    command.cancel();
                                }
                                return null;
                            }
                        });
                        return command;
                    }
                }).onSuccessTask((Continuation)new Continuation<ParseCommand, Task<Object>>(){

                    public Task<Object> then(Task<ParseCommand> task) throws Exception {
                        return ((ParseCommand)task.getResult()).executeAsync();
                    }
                }).onSuccessTask((Continuation)new Continuation<Object, Task<Void>>(){

                    public Task<Void> then(Task<Object> task) throws Exception {
                        return ParseFile.this.handleFileUploadResultAsync((JSONObject)task.getResult(), progressCallback);
                    }
                }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (!task.isFaulted()) {
                            try {
                                ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ParseFile.this.dirty = false;
                        }
                        return task;
                    }
                }).continueWith((Continuation)new Continuation<Void, Void>(){

                    public Void then(Task<Void> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    public Task<Void> saveInBackground(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseFile.this.saveAsync(progressCallback, task);
            }
        });
    }

    public Task<Void> saveInBackground() {
        return this.saveInBackground((ProgressCallback)null);
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.saveInBackground(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    public byte[] getData() throws ParseException {
        return Parse.waitForTask(this.getDataInBackground());
    }

    private Task<byte[]> getDataAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (this.data != null) {
            return Task.forResult((Object)this.data);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith((Continuation)new Continuation<Void, byte[]>(){

            public byte[] then(Task<Void> task) throws Exception {
                return ParseFile.this.getCachedData();
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).continueWith((Continuation)new Continuation<byte[], Void>(){

            public Void then(Task<byte[]> task) throws Exception {
                byte[] result = (byte[])task.getResult();
                if (result != null) {
                    tcs.trySetResult((Object)result);
                    return null;
                }
                ParseAWSRequest request = new ParseAWSRequest(ParseFile.this.url);
                request.executeAsync(progressCallback).continueWithTask((Continuation)new Continuation<byte[], Task<byte[]>>(){

                    public Task<byte[]> then(Task<byte[]> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof IllegalStateException) {
                            return Task.forError((Exception)new ParseException(100, task.getError().getMessage()));
                        }
                        if (tcs.getTask().isCancelled()) {
                            return tcs.getTask();
                        }
                        ParseFile.this.data = (byte[])task.getResult();
                        if (ParseFile.this.data != null) {
                            ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                        }
                        return task;
                    }
                }).continueWith((Continuation)new Continuation<byte[], Void>(){

                    public Void then(Task<byte[]> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    public Task<byte[]> getDataInBackground(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            public Task<byte[]> then(Task<Void> task) throws Exception {
                return ParseFile.this.getDataAsync(progressCallback, (Task<Void>)task);
            }
        });
    }

    public Task<byte[]> getDataInBackground() {
        return this.getDataInBackground((ProgressCallback)null);
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataInBackground(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataInBackground(), dataCallback);
    }

    public void cancel() {
        HashSet<Task.TaskCompletionSource> tasks = new HashSet<Task.TaskCompletionSource>(this.currentTasks);
        for (Task.TaskCompletionSource tcs : tasks) {
            tcs.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    ParseFile(JSONObject json, ParseDecoder decoder) {
        this(json.optString("name"), json.optString("url"));
    }

    JSONObject encode() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("__type", (Object)"File");
        json.put("name", (Object)this.getName());
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("Unable to encode an unsaved ParseFile.");
        }
        json.put("url", (Object)this.getUrl());
        return json;
    }
}

