/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ACRA;
import com.parse.ACRAResponse;
import com.parse.HttpConnectionProvider;
import com.parse.HttpRequest;
import com.parse.SSLConnectionProvider;
import com.parse.UnsafeConnectionProvider;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONObject;

class HttpUtils {
    HttpUtils() {
    }

    public static void doPost(Map<?, ?> parameters, URL url) throws IOException {
        HttpUtils.doPost(parameters, url, "application/x-www-form-urlencoded");
    }

    public static void doPost(Map<?, ?> parameters, URL url, String contentType) throws IOException {
        String content = contentType == "application/json" ? HttpUtils.encodeParametersJson(parameters) : HttpUtils.encodeParametersFormUrlEncoded(parameters);
        HttpConnectionProvider provider = null;
        provider = ACRA.getConfig().checkSSLCertsOnCrashReport() ? new SSLConnectionProvider() : new UnsafeConnectionProvider();
        HttpRequest req = new HttpRequest(provider);
        req.sendPost(url, content, new ACRAResponse(), contentType);
    }

    public static String encodeParametersFormUrlEncoded(Map<?, ?> parameters) throws IOException {
        StringBuilder dataBfr = new StringBuilder();
        for (Object key : parameters.keySet()) {
            Object value;
            if (dataBfr.length() != 0) {
                dataBfr.append('&');
            }
            if ((value = parameters.get(key)) == null) {
                value = "";
            }
            dataBfr.append(URLEncoder.encode(key.toString(), "UTF-8")).append('=').append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return dataBfr.toString();
    }

    public static String encodeParametersJson(Map<?, ?> parameters) throws IOException {
        JSONObject jsonParams = new JSONObject(parameters);
        return jsonParams.toString();
    }
}

