---
title: "Step 4: React to input"
subtitle: "Build your first Polymer element"
---

Of course, a button isn't a button if you can't click it. To toggle the button,
add an event listener. To add event listeners on the host element (in this
case, `icon-toggle`), add a `listeners` object to the element prototype:

icon-toggle.html { .caption }

```
  Polymer({
    /* this is the element's prototype */
    is: 'icon-toggle',
    properties: {
      toggleIcon: String,
      pressed: {
        type: Boolean,
        value: false,
        notify: true,
        reflectToAttribute: true
      }
    },
    listeners: {
      'tap': 'toggle'
    },
    toggle: function() {
      this.pressed = !this.pressed;
    },
  });
```

Key information:

*   The [`listeners object`](/1.0/docs/devguide/events#event-listeners)
    provides a simple way to set up event handlers. It maps event names to handler names.

*   The `tap` event is generated by Polymer's [gesture system](/1.0/docs/devguide/gesture-events)
    when the user clicks or taps on a target with a mouse or finger. (The `listeners` object works with built-in events
    like `keydown` and `keyup`, too.)

Save the `icon-toggle.html` file and look at the demo again. You should be able to press the button and see it
toggle between its pressed and unpressed states.

<img src="/images/1.0/first-element/databound-toggles.png" alt="Demo showing icon toggles with star and heart icons. The icons have a black border, and the pressed icons are colored red.">

**Learn more: data binding.** To see how the demo works, open `icon-toggle-demo.html`
and take a look around (if you downloaded the code, you'll find this file in the `demo` folder.)
Yes, the demo for this element is _also_ an element. The
element uses <a href="/1.0/docs/devguide/data-binding#two-way-bindings">two-way
data binding</a> and a <a href="/1.0/docs/devguide/data-binding#annotated-computed">computed
binding</a> to change the string displayed when you toggle the button.
{ .alert .alert-info }

<a class="blue-button" href="step-3">
  Previous step: Use data binding and properties
</a>

<a class="blue-button" href="step-5">
  Next step: Theming with custom CSS properties
</a>
