---
subtitle: What's in the box?
title: Polymer App Toolbox
---

Polymer App Toolbox is a collection of components, tools and templates for
building
[Progressive Web Apps](https://developers.google.com/web/progressive-web-apps)
with Polymer. App Toolbox features:

-   Component-based architecture using Polymer and web components.
-   Responsive design using the [app layout components](https://elements.polymer-project.org/elements/app-layout).
-   Modular routing using the
    [`<app-route>`](https://elements.polymer-project.org/elements/app-route) elements.
-   Localization with
    [`<app-localize-behavior>`](https://elements.polymer-project.org/elements/app-localize-behavior).
-   Turnkey support for local storage with
    [app storage elements](https://elements.polymer-project.org/elements/app-storage).
-   Offline caching as a progressive enhancement, using service workers.
-   Build tooling to support serving your app multiple ways: unbundled for
    delivery over HTTP/2 with server push, and bundled for delivery over HTTP/1.

You can use any one of these components separately, or use them together to build a full-featured
Progressive web app. Most importantly, each component is _additive_. For a simple app you may only
need app-layout. As it gets more complicated, you can add routing, offline caching, and a
high-performance server as required.

To get a feel for these components in action, you can try out the
[Shop demo](https://shop.polymer-project.org/). Shop is a full-featured e-commerce Progressive web
app demo built using the Toolbox. Read about how it's built in [Case study: the Shop app](case-study).

The [News app demo](https://news.polymer-project.org) showcases a progressive web app implementation of a News site. Read about the implementation of the News app in [Case study: the News app](news-case-study).

To get started with the App Toolbox, visit [Build an app with App Toolbox](/1.0/start/toolbox/set-up).

Or read on to find out about [Responsive app layout](app-layout).

<a href="/1.0/start/toolbox/set-up" class="blue-button">Build an app
</a>

<a href="app-layout" class="blue-button">Responsive app layout
</a>
