---
title: Publish your elements
---

<!-- toc -->

You can publish your elements on [WebComponents.org](https://webcomponents.org) to make them available on the Internet; or you can host them privately.

## Publish your elements publicly on WebComponents.org

The easiest way to make your reusable elements available is to [publish your elements on WebComponents.org](https://www.webcomponents.org/publish).

Before you publish on WebComponents.org, create a GitHub repository for your element. Make sure your repository has the following:

* An [open source license](https://opensource.org/licenses/alphabetical). Refer to the instructions inside the your chosen open source license for advice on how to apply the license to your code. Usually, this involves adding a license comment to the top of your source files. You can also put a copy of the license in a LICENSE.txt or LICENSE.md file in your GitHub repository.

* A tagged release. [See the GitHub documentation for advice on how to create a taggged release](https://help.github.com/articles/creating-releases/).

* A README file. Create a README.md for your repository. Here's a template you can use: [A template for Github READMEs (Markdown)](https://gist.github.com/zenorocha/4526327).

You should also document and test your elements before publishing. See [Document your elements](documentation) and [Test your elements](tests).

Once you've done this, you're ready to go. Return to the [Publish page at WebComponents.org](https://www.webcomponents.org/publish). Follow the instructions on the Publish page to add a badge and an inline demo to your element. 

## Host your elements privately with indie-catalog

If you have elements that can't be made public, you can host them locally with [indie-catalog](https://github.com/PolymerLabs/indie-catalog).





