---
title:  "1.0"

---
_We announce significant releases here on the blog, highlighting the major new features as well as breaking changes. As always, we'd love to get your feedback, issues, and PR's, so tweet us [@polymer](https://twitter.com/polymer) or contribute to the [Github](https://github.com/Polymer)._

Today we’re incredibly excited to announce the 1.0 release of the Polymer library.

Since the 0.5 “Developer Preview” release, we’ve re-written the library from the ground up, focusing on cross-browser performance while keeping the developer-friendly ergonomics. The new library is 3x faster on Chrome, 4x faster on Safari, and 36% less code than in developer preview. And it’s ready to be used in production applications.

For 0.9 users, this release has no breaking changes. Lots has changed under the hood, including major bug fixes and performance updates. We recommend updating all of your element dependencies to match this new version: `#^1.0.0`

In addition to the library, we’re officially releasing new “product lines” of elements, all updated to work with the 1.0 release of the library. The element product lines built by the Polymer team include:

* **paper-elements** - the reference implementation for material design on the web
* **iron-elements** - the core building blocks useful for any web application
* **google-web-components** - elements that wrap a multitude of Google services, making it easy to leverage maps, drive, signin, translate, and many more in your app with a single element.
* **platinum-elements** - add push notifications or offline caching to your app with a single element. The platinum product line wraps the new re-engagement API’s like service worker as easy-to-use elements.
* **gold-elements** - checkout flows are hard on the web, especially on mobile. The gold-elements make checkout easy with auto-validating elements for credit card fields, phone number fields, and more.

This is just the beginning of these product lines - we'll be refining the elements, evolving the set, and adding new product lines to solve more and more problems that come up when building applications.

### Get started with the new library

We’ve updated the [polymer-project.org](https://www.polymer-project.org) site with documentation for the 1.0 release. Major new and updated features since the 0.5 “Developer Preview” release include:

* Brand-new, fast, and easy-to-use data binding system
* Element theming and styling using custom CSS properties - no more messy `/deep/` and `::shadow`
* Fast and lightweight shadow DOM shim named shady DOM, for non-supporting browsers
* "Behaviors” mechanism for sharing behavior between elements

It’s easier than ever to create high-quality, production-ready elements using Polymer, to use in your app or share with other developers.

### Browse, demo, and learn how to use the latest elements built by the Polymer team

Check out the many brand-new element product lines built by the Polymer team with the [Polymer elements catalog](https://elements.polymer-project.org). There you can browse for elements to help create or add features to your web app - whether you need buttons or layouts, Google maps or push notifications. For just about any problem you might need to solve on the web, there’s an element for that.

### Kick off your app with the Polymer Starter Kit

Looking for a fast and easy way to get started building a production-ready web application using Polymer? Use the [Polymer starter kit](https://github.com/polymerelements/polymer-starter-kit). Packed with the latest elements, ready-to-use boilerplate, and an end-to-end toolchain to use from development through production deployment, the starter kit works out of the box so you can focus on adding features right away.

### Most importantly, thank you!

This release and improvement from 0.5 to 1.0 would truly not have been possible without the immensely helpful, insightful, rapid feedback from you, the community. We don't mean this as a platitude - seriously on a daily basis we're deeply appreciative of the [awesome bug reports](https://github.com/webcomponents/webcomponentsjs/issues/299), [incredible tools](http://chuckh.github.io/road-to-polymer/), and [amazing GDE's](https://plus.sandbox.google.com/+ErikIsaksen/posts/BcBFZvdxLhs) that make this project and community truly special.

We’re incredibly excited about this release and the present and future of the Polymer project, and can’t wait to see what you’ll build!
