---
title:  "1.1 Release"

---
_We announce significant releases here on the blog, highlighting the major new features as well as breaking changes. As always, we'd love to get your feedback, issues, and PR's, so tweet us [@polymer](https://twitter.com/polymer) or contribute to the [Github](https://github.com/Polymer)._

It's been a while since our last post - we've been heads-down on follow-up from the 1.0 release! A big thank you to everyone for the excellent and extremely helpful Github issues and pull requests. Lots of bug fixes and perf improvements have been going in, as well as a number of updated 1.0 components (more on these soon). But today we're especially pleased to announce:

## Polymer 1.1

This is a relatively small, **minor** release - no breaking changes, and only one feature addition:

### New style recommendations and features

We've built  a new way to share styles between elements. The impetus stemmed from [this issue](https://github.com/Polymer/polymer/issues/1876): that given a user has made a `custom-style` for something like layout, it would be useful to use these same styles at the document-level as well as within an element itself.

Previously, for example, if I wanted to share the following style:

    .warning {
      color: red;
      font-weight: bold;
    }

in both the main document as well as within elements and have it shimmed correctly, I would have needed to duplicate the exact CSS.

This was particularly painful for CSS being used for something like layout classes, as well as for general "theme" CSS. If I wanted the styles to apply both in the document as well as in elements, I needed to duplicate the style.

So we set out to find an ergonomic way to "include" a shared chunk of style directly into an element, as well as into a document-level `<style is="custom-style">` element. The notion of a `dom-module` in 1.0 is to identify a generally useful chunk of DOM to be reused elsewhere - this of course can include a `<style>` tag as well. We landed on the following syntax:

    <!-- shared-styles.html -->
    <dom-module id="shared-styles">
      <template>
        <style>
          .warning {
            color: red;
            font-weight: bold;
          }
        </style>
      </template>
    </dom-module>

This chunk of DOM - identified by its `shared-styles` id - can now be included into an element using the following syntax:

    <!-- using shared styles in an element -->
    <link rel="import" href="../shared-styles/shared-styles.html">

    <dom-module id="x-foo">
      <template>
        <style include="shared-styles"></style>
        <style>:host { display: block; }</style>

        <div class="warning">Uh oh!</div>
      </template>
    </dom-module>

You can also include a shared style in a `custom-style` - that is, including shared styles to be used in the main document. The syntax for this is:

    <link rel="import" href="../shared-styles/shared-styles.html">
    <style is="custom-style" include="shared-styles"><style>

One chunk of CSS, used both in the document and within an element.

This new feature also comes with a change in how we recommend using styles in elements.

Previously, we recommended that a `<style>` element should be placed inside an element's `<dom-module>` but outside of its template. This is still supported, but we've now optimized placing styles within the template itself, so having the `<style>` tag outside of the template will be slower. We will be updating all of the elements provided by the Polymer team to match this new recommended behavior as well.

A final important note: The previous `<link rel="import" type="css">` is still supported, but will eventually be deprecated. This syntax allowed users to include a `.css` file directly into an element, but browser vendors may remove the ability to bring in a file like this and parse it as HTML, so we're looking to get out in front of this change. We will be providing a tool to help turn `.css` files into the format above shortly, but we wanted to get the feature itself in the library as soon as possible.

As always, if you have any questions around how this works, please feel free to use the [polymer tag](http://stackoverflow.com/questions/tagged/polymer) on StackOverflow, or join us on the Polymer [Slack Channel](http://polymer-slack.herokuapp.com/).
