---
title:  "Polymer Summit Recap"
---

In case you missed any of the action at this year's Polymer Summit, we focused on three key themes: Develop, Design and Deploy, giving concrete advice on how you can build your web app from start to finish. Here's a recap of all the highlights.

### Keynote

In the Keynote, we talked about how the Polymer core team is thinking about Polymer's past, present, and future.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/jVn8tlnwAEs" frameborder="0" allowfullscreen></iframe></div>

## Develop

The sessions below will help you learn about all the features that Polymer and the element product lines provide.

### Thinking in Polymer

Polymer embraces encapsulated Custom Elements as its main organizing unit. This simple-sounding concept is actually an incredibly powerful tool that can revolutionize how you think about solving complex problems, collaborate within large teams, reduce technology lock-in, and of course, build amazing apps for the web. Hear how we think about building apps using custom elements directly from one of the Polymer core team engineers, and how to best employ this simple concept for the most leverage in your own projects.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/ZDjiUmx51y8" frameborder="0" allowfullscreen></iframe></div>

### End-to-End with Polymer

Polymer and Web Components are exciting, but developers are not always sure how to connect the dots to get a full blown, production-ready app. Where should you store your data? How do you handle user authentication? What are the patterns that make up a good Polymer app? In this session Rob answers these questions, and guides you through the process of building an awesome offline-first Progressive webapp using Polymer Starter Kit, the Platinum elements, and Firebase.

Project Source: [https://github.com/polymerlabs/todo-list](https://github.com/polymerlabs/todo-list)


<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/1f_Tj_JnStA" frameborder="0" allowfullscreen></iframe></div>

### Using ES6 with Polymer

Polymer's mission is to evolve with the modern web. In this talk, we'll take a look at the new features in ECMAScript 2015 (aka ES6), how to use them today, and what role they play in Polymer's future.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/bX3_tN23M_Y" frameborder="0" allowfullscreen></iframe></div>

### Testing Polymer Web Components

This session will include a rundown of test environment helpers the Polymer team has created, the new test-fixture element and the accessibility testing functionality added to WCT. Chris also covers examples of different non-trivial testing scenarios related to web components and provides strategies to address them.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/kX2INPJY4Y4" frameborder="0" allowfullscreen></iframe></div>

### Platinum Elements

Web Components aren't the only hot new thing on the web. Learn about how we're bringing the magic of Polymer to brand new Web Platform features like Offline, Push Messaging, and Background Sync.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/EXn-Zr-qmqo" frameborder="0" allowfullscreen></iframe></div>

### There's an Element for that - but what if there isn't?

You have your own service. It has a very nice API. Is there an element for that? Probably not! In this session Surma talks about patterns to follow when writing your own elements to wrap an API or to create new visual components.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/qogKAkxrfrk" frameborder="0" allowfullscreen></iframe></div>

### a11y with Polymer

One in six people will experience a disability at some point in their life, so it's crucial for sites and apps to work smoothly for users with a wide range of abilities. A well crafted site is usable whether or not a person can see, use a mouse, or distinguish red from green - to mention just a few of the assumptions we inadvertently make. Learn about how and why we hold the Polymer 1.0 widget set to a high bar for accessibility, and how you can use the Polymer libraries to create your own accessible custom elements.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/o6yLWihykVA" frameborder="0" allowfullscreen></iframe></div>

### Upgrading to 1.0 with Polyup

A lot changed from Polymer 0.5 to 1.0! Fortunately you don't have to upgrade all of your code by hand, polyup will do a lot of the work for you. We'll walk through upgrading a full app from 0.5 to 1.0 in under ten minutes, and what a tool like Polyup means for building apps out of Polymer-based elements.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/maygsoPKLpE" frameborder="0" allowfullscreen></iframe></div>

### Polymer's Gesture System

A look at the breadth and depth of Polymer's built-in gesture library, and how your elements can be interactive, responsive, and cross-platform.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/EUpUz3RUvdc" frameborder="0" allowfullscreen></iframe></div>

## Design

In these sessions, find out how Polymer can help your apps look and work great for all your users.

### Adaptive UI with Material Design and Paper Elements

A look at the breadth and depth of Polymer's built-in gesture library, and how your elements can be interactive, responsive, and cross-platform.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/YiiXKoLYLMo" frameborder="0" allowfullscreen></iframe></div>

### Polymer's Styling System

Traditionally, CSS stylesheets have a terrible opinion about style encapsulation: the only thing stopping one element’s style from stomping over another’s is a “well chosen class name”. The Shadow DOM fixes this by building a little castle and a moat around each element, so that styles can’t get in and out of the web component castle. But what happens if you _do_ want to style this custom element? How do you cross the moat? Custom properties, that’s how.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/IbOaJwqLgog" frameborder="0" allowfullscreen></iframe></div>

### Polymer's Animation System

Great transitions and animations are an important part of your web application's visual design. However building them using CSS and Javascript is not always straightforward. In this talk we'll cover how neon-animation system helps you build animations in Polymer and we'll build some page transitions.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/-tX0e29GQa4" frameborder="0" allowfullscreen></iframe></div>

## Deploy

Discover how to make sure your Polymer app is blazing fast.

### Polymer Power tools

In 2015, framework-less web development using elements + micro-libraries can get you really far on the web platform. It's powerful. We'll cover the tools now available to help you build with Polymer in production including Polymer Starter Kit, Polyup, Vulcanize, Crisper, web-component-tester, our docs and code viewer tools and much more!

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/LMqM4PfrFxs" frameborder="0" allowfullscreen></iframe></div>

### Doing a Perf Audit of your Polymer app

Performance is measured from the ground truth of the browser internals, and you're operating a few levels up, with the DOM, framework code, and JavaScript sitting between your users finger and the resulting screen paints. In this session Paul Irish will show how the Chrome DevTools can help you understand where time is spent in your app and effective means of profiling your performance. You'll walk away with a solid understanding of how your polymer work can be as fast-loading and responsive-to-the-touch as you like.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/SkN5Q7nf7Vg" frameborder="0" allowfullscreen></iframe></div>

### Polymer Performance patterns

Let's face it, building a web app is hard. There's a lot to remember! Web components allow us to componentize the web's best practices but that doesn't mean footguns are a thing of the past. In this talk, we cover tips and tricks for speeding up first paint, lazy loading components, and various runtime optimizations.

<div class="video-embed"><iframe width="560" height="315" src="https://www.youtube.com/embed/Yr84DpNaMfk" frameborder="0" allowfullscreen></iframe></div>
