---
title:  2016 Roadmap
---

We wanted to share our roadmap for the Polymer project for the next 6 months or so - lots of exciting features and updates on the horizon. Of course, things don't always go as planned so we fully expect some of this will change, and we'd especially love your feedback and any questions: this roadmap will also be posted and continually updated at [https://github.com/polymer/project](https://github.com/polymer/project), so feel free to use the [issue tracker there](https://github.com/polymer/project/issues) for any questions or thoughts. A great way to track progress on all of these efforts will be to simply watch the [https://github.com/polymer/project](https://github.com/polymer/project) repository, and of course to follow this blog.

### Building Applications with Polymer

We see [Progressive Web Apps](https://developers.google.com/web/progressive-web-apps?hl=en) as a big part of the future of the web - web applications that take ["all the right vitamins"](https://infrequently.org/2015/06/progressive-apps-escaping-tabs-without-losing-our-soul/) to be added to a user's homescreen, work while the user is offline, send a user push notifications, and more. Many of these types of features that [Service Worker](http://www.html5rocks.com/en/tutorials/service-worker/introduction/) provides also marry extremely well with a component-driven, tight-to-the-platform development model supported by Web Components. We want to publish more around how we see these pieces playing together - how to build on the web platform the way it is intended - and also provide a suite of tools to actually manifest these ideas.

*Goals*:

- Prototype all the pieces needed to build a complete Progressive Web App with Web Components and Service Worker
  - Publish philosophy around how to structure a web component-based progressive web app - building on the web the way the platform intended!
  - Ship a routing solution
  - Ship a lazy-loading solution
  - Ship a l10n/i18n solution

### Element Maintenance and Performance

Much of the core Polymer team's time is spent fixing issues on existing Polymer elements. We're incredibly eager to push forward with new elements to solve new problems, but need to get a handle on the existing maintenance burden. We're approaching this from multiple angles - continually improving quality and fixing bugs, improving the core Polymer team's tools and systems for maintenance, and aiming to be better contributors to the open web components ecosystem.

We're extremely bullish about this growing web component ecosystem, and excited to help it grow in any way we can. We'll lay out in a follow-up blog post many of the ways we're hoping to make it easier and clearer to contribute to the Polymer project, improve turnaround from within the Polymer core team, and better promote community-built web components.

*Goals*:

- Reduce and achieve sustainable element maintenance costs
  - Help promote community-driven elements and bring in additional maintainers from the community.
  - Increase number of merged community Pull Requests to elements by 100%
  - Keep time-to-triage for incoming element issues < 5 days.

We're also always looking for opportunities to improve element performance. We'll particularly be taking a hard look at elements that may be used many times on a single page - things like [paper-input](https://elements.polymer-project.org/elements/paper-input) and [iron-icon](https://elements.polymer-project.org/elements/iron-icon) - to make them as fast and lightweight as possible.

*Goals*:

- Improve our offering of high-performance elements
  - Identify high-use elements and ship ultra-lightweight versions
  - Iterate on and share element performance measurement techniques and benchmarks

### Application Layout and Templates

Over the last two years we've been exploring building elements that take the pain out of constructing responsive layouts. We've learned a lot through this process - including shipping many responsive elements within the paper and iron element sets - and have recently been working on a new group of elements to improve the ergonomics and flexibility for building responsive layouts that aren't necessarily tied to material design.

We're incubating this set of elements within the experimental [app-layout elements](https://github.com/PolymerLabs/app-layout) repository. In 2016, we want to polish and ship these new elements and tie them more tightly into the broader mission of making it easier to build large apps with Polymer.

### Core Polymer Library

One of the major value propositions of Polymer is that it gets out of your way - it lets you build as close to the web platform as possible, heavily leveraging many of the critical features of Web Components. It isn't a massive, complex, heavyweight abstraction away from the actual browser - it's just a sugaring on top of the features the browser itself provides. We want to continue pushing the library to fully realize this strength.

With Polymer 1.0, the Polymer library was actually a combination of 3 different "layers" of sugaring on top of Web Components. We [experimentally exposed these layers](/1.0/docs/devguide/experimental#feature-layering), to attempt to allow element authors to opt-in to additional features of Polymer.

The feedback we've gotten on this layering is that the idea is sound, but the actual feature division between the layers missed the mark. We're focusing now on re-working this layering to make it easier to build super-minimal elements, and to opt-in to additional library features.

We also have planned on adding inheritance back into Polymer, as it was dropped in Polymer 1.0 in favor of composition and behaviors. We've found though that this has sometimes lead to an overuse of composition to just slightly tweak a few features of an element. We want to ship a straightforward inheritance pattern so that developers can cheaply extend existing elements.

*Goals*:

- Evolve Polymer library towards a opt-in cost model
  - Ship inheritance
  - Design a relayering of Polymer

Shadow dom and custom elements are also right around the corner in all major browsers - all vendors have [agreed](https://annevankesteren.nl/2016/02/custom-elements-no-longer-contentious) on v1 versions of [these](https://www.w3.org/TR/shadow-dom/) [specs](http://w3c.github.io/webcomponents/spec/custom/) and are working hard on [implementing](https://webkit.org/blog/4096/introducing-shadow-dom-api/). We want to prepare the Polymer library and all of our elements for the changes that come with these new specs, to make for a smooth transition. This may mean some minor breaking changes for elements and the library, but broad browser support without the need for polyfills will be an incredible leap forward.

*Goals*:

- Make the Polymer library compatible with latest web component specs and shipping implementations
  - Update styling system to be compatible with custom properties
  - Update shady DOM to be compatible with shadow dom v1
  - Update custom elements treatment to be compatible with custom elements v1

### Address user feedback on data system

One of the common recurring pieces of feedback we hear about Polymer is confusion in the data binding system. We're looking to help make it clearer how to interface with data binding, to get all the lightweight sugar without some of the cognitive overhead when it comes to large, interconnect data models. This may come in the form of creating new library features, evolving existing features, building additional layers on top, or improving clarity in the Polymer documentation - or most likely some combination of all of the above.

### Tooling

The Polymer team works on [a](https://github.com/Polymer/polyserve) [lot](https://github.com/Polymer/vulcanize) [of](https://github.com/Polymer/polygit) [tools](https://github.com/PolymerLabs/crisper) to improve the development workflow and enable fast deployed sites. Many of these [tools](/1.0/docs/tools/overview) can get lost or buried, and it can be complicated to figure out how they might work together.

We want to keep all of the tools modular, but for simplicity and better discovery we're exploring building a wrapped-up "Polymer CLI," that includes the tools we build for Polymer development. Currently we're focusing only on Polymer-specific tools - for things like package management we want to continue to rely on the most commonly-used tools in the broader ecosystem that fit the development model.

*Goal*:

- Prototype Ultimate Polymer CLI

### Community and Ecosystem

The Polymer community has grown incredibly quickly and there are a number of individuals making extremely meaningful contributions to both the library and Polymer elements. We want to do more to highlight community work and generally better serve the Polymer and web components ecosystem. This means even more transparency around the core Polymer team's roadmap, more regular announcement and updates, and promoting element ownership beyond just the core Polymer team.

*Goals*:

- Accelerate Polymer + Community engagement
  - Tighten the core Polymer team and community feedback loop - better evolve Polymer as the community evolves
  - Publish all elements to npm and bower
  - Regularly publish project and roadmap updates
  - Work with community members to help drive elements forward
  - Use [Polycasts](https://www.youtube.com/playlist?list=PLOU2XLYxmsII5c3Mgw6fNYCzaWrsM3sMN) and builtwithpolymer.org to highlight awesome elements being built
