---
title:  "I/O 2016 Recap: #UseThePlatform"
---

We had a great time at Google I/O 2016 last week, where we met hundreds of developers; helped
spread the word about [Progressive Web Apps](https://developers.google.com/web/progressive-web-apps/);
and unveiled the [PRPL pattern](https://www.youtube.com/watch?v=J4i0xJnQUzU), the
[Polymer App Toolbox](/1.0/toolbox/), and our [new-and-improved website](/).

For those of you who weren’t able to join us in person or online, we’ve compiled [a collection
of videos](https://www.youtube.com/playlist?list=PLNYkxOF6rcIDnSm7bZRJC36Ca1DYXSQ70) you can
watch, and you’ll find our [original I/O blog post here](/1.0/blog/2016-05-19-Polymer-IO-2016.html).

## <a id="use-the-platform"></a>What we mean by #UseThePlatform

One other thing we unveiled at I/O was our new motto-in-hashtag-form, **#UseThePlatform**, which
captures the essential mission of the Polymer Project.

Our project was founded on the premise that—as we complete the transition to a
resource-constrained, mobile-first web—we need to lean more heavily on the web platform to give
users and developers the experiences they deserve.

In calling you to **#UseThePlatform**, we’re asking you to join us in rethinking some development
patterns we’ve been using for years—patterns that involve working extensively above and
around the web platform.

These patterns were born of necessity. When we first started writing web apps the web
platform was ill equipped to support us, so we needed to do a lot of heavy lifting ourselves.
Our collective efforts have yielded some brilliant ideas and great results.

But building thick layers on top of the platform is inherently costly, and the costs are much
harder to bear on mobile, where more users are today. We can reduce these costs if we embrace
the modern web platform to its full potential.

To be clear, we don’t think JavaScript is bad, and we don’t think libraries and frameworks are
bad either—we’ve been writing them for years. They fill gaps in the platform, and provide
useful abstractions for developers. We are all allies in building a better web.

But the web is changing: users are consuming it differently, and the platform now offers us an
arsenal of powerful features to help us build apps. We all have to adapt. Frameworks shouldn’t
go away, but we think they can and should be leaner.

## <a id="about-the-polymer-project"></a>About the Polymer Project

For more on this topic, we invite you to check out our new [About the Polymer Project](/about)
page, which describes our mission and explains **#UseThePlatform** in greater depth.
