---
title:  "Polymer 2.0 Preview"
---

Today we pushed a [`2.0-preview`](https://github.com/polymer/polymer/tree/2.0-preview) branch to the Polymer repository, where we’re working on the next major version of the library.

Polymer 2.0 is a minimally-breaking change from the current library, with a few very precise goals:

### Take advantage of native [v1 Shadow DOM](https://developers.google.com/web/fundamentals/primers/shadowdom/) and [v1 Custom Elements](https://developers.google.com/web/fundamentals/primers/customelements/) API’s

The primary goal of the Polymer 2.0 release is to take advantage of native, cross-browser support for Web Components.

Polymer 1.x is built on top of the so-called "v0" Web Components specs, which are supported natively only in Google Chrome; using Polymer in other browsers has always required the use of polyfills.

Beginning this fall, multiple browsers will be shipping native implementations of the new "v1" specs for Shadow DOM and Custom Elements, yielding better web components performance and reducing the need for polyfills. [Safari](https://developer.apple.com/library/prerelease/content/releasenotes/General/WhatsNewInSafari/Articles/Safari_10_0.html#//apple_ref/doc/uid/TP40014305-CH11-DontLinkElementID_5) and  [Chrome](https://www.chromestatus.com/features/4667415417847808) are already shipping Shadow DOM v1 support, and support in other browsers is well on its way.

Polymer 2.0 features full support for the v1 specs, taking advantage of native browser implementations where they are available and depending on updated v1 polyfills from [webcomponentsjs](https://github.com/webcomponents/webcomponentsjs/tree/v1) where necessary.

Polymer 2.0 also embraces ES6 classes for defining custom elements. Authoring a custom element using Polymer is even closer to authoring one with "vanilla" custom elements.

### Provide smooth migration from Polymer 1.x

In order to make it as easy as possible for existing Polymer components to take advantage of the v1 Web Component API’s with minimal pain, we want the 1.x => 2.0 transition to be as smooth as possible.

To upgrade, you will need to make [some changes](https://github.com/Polymer/polymer/tree/2.0-preview#breaking-changes) to your 1.x-based code. These changes are necessitated by both the v0-to-v1 spec transition and a handful of key improvements in Polymer itself.

However, we've taken care to limit the number of changes that are strictly required and to ease the process of upgrading:

* Polymer 2.0 introduces a number of new idioms and best practices, but we've provided a lightweight compatibility layer allowing you to upgrade your 1.x code with minimal modifications. Depending on your needs, you can either take advantage of the compatibility layer or jump straight to idiomatic 2.0 style.

* Before releasing Polymer 2.0, we'll also provide an upgrade tool to automate as many of the changes (both required and recommended) as possible.

* We're working on guidelines for building and testing "hybrid" elements that will run in both Polymer 1.x and Polymer 2.0. We plan to ship hybrid versions of all of the elements that we provide, easing the transition for developers who use them. Third-party element providers may also choose to ship hybrid elements for the time being.

* If you have an especially large app or constraints that don't allow you to upgrade right away, you can use hybrid elements to migrate your app from 1.x to 2.0 in piecewise fashion: update your elements to hybrid form, individually or in batches, while running against Polymer 1.x; then cut over to Polymer 2.0 when all of your elements have been updated.



### Eliminate leaky abstractions

Seamless interoperability is one of Web Components' major selling points. Generally speaking, web components "just work" anywhere you use HTML elements. To use them, you need only be aware of their public attributes, properties, methods and events; you don't need to know anything about their inner workings. This means you can easily mix standard HTML elements, third-party elements and elements you've defined yourself.

Unfortunately, there are a couple of cases in Polymer 1.x (the `Polymer.dom` API and the `set`/`notifyPath` API) where implementation details of Polymer-based elements leak out, requiring users to interact with them in non-standard ways. These "leaks" were by design – compromises we chose to make in the interest of performance – but in hindsight we weren't happy with the tradeoff.

In Polymer 2.0 we've found ways to eliminate these leaky abstractions without unduly compromising performance. Polymer 2.x-based elements will be indistinguishable from "vanilla" custom elements from a consumer's point of view.

### ES6 class-based syntax, with Polymer compatibility layer

The 1.x `Polymer({})` factory is an all-in-one way to build a custom element. It lets you define the element’s API, handles registering the element, sugars over its native custom element lifecycle callbacks, and much more. This can be extremely convenient, but also forces a level of abstraction that takes you further from using what the platform itself provides.

In addition to providing a nearly backwards-compatible Polymer function to define your element, Polymer 2.0 will also support an ES6 class-based way to define a custom element - letting you truly [use the native web platform](https://www.polymer-project.org/about) features without getting in your way. You’ll be able to define a custom element by writing:

```js
class MyElement extends Polymer.Element {
  static get is() { return ‘my-element’; }

  static get config() {
    return {
      properties: {
        //the properties you know and love from Polymer
      },
      observers: [
        //the observers you know and love from Polymer
      ]
    }
  }

  constructor() {
    super();
    …
  }
}

customElements.define(MyElement.is, MyElement);
```


### Improved factoring for more flexible usage

We've done some refactoring of Polymer and the webcomponentsjs polyfills to improve efficiency, utility and flexibility:

* The "Shady DOM" shim that was part of Polymer 1.x has been factored out of Polymer and added to the webcomponentsjs polyfills, along with the related shim for CSS Custom Properties. The Shady DOM shim also no longer exposes an alternative API (`Polymer.dom`) and instead supports calling the native DOM API directly on your custom element.

* Polymer itself has been internally factored into several loosely coupled libraries.

  * The new `Polymer.Element` class extends from the native `HTMLElement` and mixes in functionality from these libraries. The idiomatic way of using Polymer 2.0 (assuming you're not using the 1.x compatibility layer) is to define your own custom elements that subclass `Polymer.Element`, using standard ES class definition syntax.

  * If you're interested in using pieces of Polymer's functionality in _a la carte_ fashion, you can try defining your own base element class, utilizing a subset of the libraries.


### Feedback requested!

For more detailed documentation on the `2.0` branch as it evolves, see the [README](https://github.com/Polymer/polymer/blob/2.0-preview/README.md) included in the repository. We’d love your feedback on this early development release - please leave issues directly on the repository, or shoot us a tweet [@Polymer](https://www.twitter.com/polymer).

Over the next couple months, we’ll be continuing to iterate on the API. We’ll also be upgrading the [elements built by the Polymer team](https://elements.polymer-project.org) to be built on top of 2.0.

We'll also be talking a bunch more about Polymer 2.0 at the upcoming <a href="/summit-2016/" target="_blank">Polymer Summit</a>. Looking forward to hearing what you think!
