---
title:  "1.7 Release"

---
_We announce significant releases here on the blog, highlighting the major new features as well as breaking changes. As always, we'd love to get your feedback, issues, and PR's, so tweet us [@polymer](https://twitter.com/polymer) or contribute to the [Github](https://github.com/Polymer)._

The primary goal of the upcoming Polymer 2.0 release is to take advantage of native, cross-browser support for Web Components. With this in mind, we're pleased to release Polymer 1.7, which introduces features allowing you to use 2.0-compatible syntax in 1.x elements.

## Polymer 1.7

Polymer 1.7.0 provides forward compatibility features that let you build elements that run under both 1.0 and 2.0. 

While you can use these features now, the team intends to release a tool to help automate these changes. If you have a large project, you might want to wait for the migration tool to be available.

The new syntax is not required for current Polymer 1.x elements, but using the new syntax will make it easier to port elements to 2.0, which requires it.

### `<slot>` element 

Elements can opt-in to using the new `<slot>` element and `::slotted()` CSS selector from shadow DOM v1.

These replace the `<content>` element and `::content` selector in shadow DOM v0. The v1 API is somewhat more restrictive, so you should read up on the details before making changes.

### `html` selector in `<style is="custom-style">`, `:host > * ` selector in elements

Polymer 2.0 removes support for the `:root` selector. In a `custom-style` element, you can use `html` where you used to use `:root`. Inside an element, you can use `:host > *`.

Polymer 1.7 adds support for using the `html` selector in a custom-style element, so you can use the 2.0-compatible syntax. (The `:host > *` syntax was already supported.)

For more details, read the full release notes here: <a href="/1.0/docs/release-notes#v-1-7-0">Release 1.7.0</a>
