---
title:  "2.0 is on the way!"

---

As many of you know, we’re _almost_ ready to release the newest version of Polymer. Our goal is to make it simple to build high-quality, performant web applications with high-quality, performant Web Components. Polymer 2.0 uses native ES6 class-based syntax for optimal interoperability and simplicity.

Our Polymer 2.0 release comes with more than changes to the Polymer library. We’ve created a fresh fleet of updated demos, documentation, templates, and the Polymer Project’s [catalog of elements](https://elements.polymer-project.org/). You’ll also have access to a suite of Web Components Tools that are designed to work with all Web Components, including those written in vanilla JavaScript.  
 
So where are we now? The Polymer 2.0 preview branch and the v1 webcomponents polyfills now support all of the major features and changes we set out to implement for Polymer 2.0.  These include:
* Support for the V1 web components specs and an ES6 class-based syntax
* Implementing new polyfills for V1 custom-elements and HTML Imports
* Separating the shady DOM and styling polyfills out of Polymer proper as standalone polyfills under webcomponentsjs and reworking it to eliminate the Polymer.dom API
* Making targeted changes to the data system to address key feedback from 1.x users
* Providing a legacy API to enable easy 1.x - 2.0 transition and hybrid elements that will run on either version.

With the crux of the core library complete, we are focusing more on improvements and optimizations as we run performance and stability tests. These final tasks are to:
* Improve data system backward-compatibility with 1.0, including fine-tuning the lifecycle of a property change
* Customize Shady DOM's native API patching optimally for each browser's capabilities
* Finalize API for ES6 class-based syntax
* Update Shady CSS build-time style transformer (formerly known as [https://github.com/PolymerLabs/polymer-css-build](https://github.com/PolymerLabs/polymer-css-build)) for the V1 polyfill
* Ensure Cross-platform robustness, including support for older browsers (esp. IE11) as well as latest Safari Tech Preview's native webcomponents implementations
* Implement array-selector
* Support dom-if and dom-repeat used within parser-restricted elements (e.g. table, select) without relying on CE type extension
* Optimize overall library performance
* Support Closure Compiler's advanced compilation

We already have **70% of elements ported to Polymer 2.0 Hybrid Mode**, and began testing simultaneously for Polymer 1.x and Polymer 2.0 compatibility. We have also built new element features to support Web Components v1 where needed. Now, we are testing our elements and improving the compatibility and stability of the Web Components polyfills.

Our [app-layout elements](https://github.com/PolymerElements/app-layout/tree/2.0-preview) and all templates are ported to 2.0, including [pesto](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/pesto), [publishing](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/publishing), [shrine](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/shrine), [getting-started](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/getting-started), [landing-page](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/landing-page) and [test-drive](https://github.com/PolymerElements/app-layout/tree/2.0-preview/templates/test-drive). The [Shop app](https://github.com/Polymer/shop/tree/2.0-preview) demo has also been upgraded. Similar to the elements, our current goal is to ensure that the apps and demos are working smoothly on all supported browsers.

We’ve been hard at work on a number of Tools updates to support Polymer 2.0, hybrid elements, and Custom Elements v1. Because Custom Elements are written as ES6 classes, but not all browsers currently support ES6, we are adding built-in compilation support across multiple tools. 
* `polymer serve` and `polymer test` now automatically compile all JavaScript from ES6 to ES5 for browsers that need it. 
* `polymer build` is adding a number flags to control compilation and bundling.

To support testing hybrid elements across Polymer 1.x and 2.x dependencies, we've introduced "[dependency variants](https://github.com/Polymer/polymer-cli#dependency-variants)" and the `polymer install --variants` command. We've also updated our multi-repo test automation tool, [Tattoo](https://www.npmjs.com/package/tattoo), to work with any set of repos, so you can test entire suites of elements against Polymer 1.x or 2.x.

The new Polymer Analyzer will power documentation for Polymer 2.0-based elements. Soon, the Analyzer, Linter, and Bundler will be integrated into the CLI with full Polymer 2.0 support. We've added the `polymer analyze` command to show what the Analyzer understands about an element.

With most of the team heads-down on interoperability and compatibility testing, the Polymer 2.0 release is not far away! There's still a lot left to do, but we're aiming to get 2.0 to you in the first quarter of 2017. If you’re itching to get started, now is a great time to check out our Polymer 2.0 preview branch -- our templates and most of our elements are available to you there. **For a guided sneak peek at Polymer 2.0, we have a [Codelab](https://codelabs.developers.google.com/codelabs/polymer-2-carousel/#0) showing how to write a Polymer 2.0 element** using ES2015 syntax. It covers changes in Custom Elements V1 and Shadow DOM V1, using mixins to factor out common code, and considerations to make when designing your element’s API. You can also watch Rob Dodson’s Polymer Summit talk, [Polymer 2.0: Under the Hood](https://www.youtube.com/watch?v=iJ9hS54BRag) to get an explanation of how the 2.0 internals complement existing APIs to help you build efficiently. 