---
title:  "webcomponents.org"

---

In the last few years, the Web Components community has grown immensely. The [Polymer Slack channel](http://bit.ly/polymerslack) has over 6,000 members, and there are thousands of Web Component repositories on Bower. And with the new “v1” versions of the [Shadow DOM](https://developers.google.com/web/fundamentals/getting-started/primers/shadowdom) and [Custom Elements](https://developers.google.com/web/fundamentals/getting-started/primers/customelements) specs, Web Components are now gaining broad cross-browser support.

The [webcomponents.org](https://www.webcomponents.org) site has been an excellent home for the Web Components world for a number of years, with articles on how to get started with Web Components as well as content and updates from the broader community. We’re extremely excited for today’s major update to the site, with all the great content you know and love as well as a built-in catalog for high-quality, community-built web components.

Check out the [hundreds of web components published](https://www.webcomponents.org/elements) there already, [publish your own](https://www.webcomponents.org/publish), or browse and create a [collection of elements](https://www.webcomponents.org/collections) that go together.

The catalog is full of features that let you explore the world of custom elements, and show off your own published components in their best light. Features include:

* Rich component search, including live suggestions and search over collections of components.
* Detailed component activity information, so you can make an informed choice based on how active an element’s repo is.
* Live, editable inline demos in your element’s README. We have one for the [`paper-progress` element](https://www.webcomponents.org/element/PolymerElements/paper-progress).
* Auto-generated API documentation. This is currently supported for [documented Polymer-based elements](https://www.polymer-project.org/1.0/docs/tools/documentation), and the team is working to add support for other web component libraries as well as vanilla web components.
* Assembling elements into collections. For many web components, like the [paper elements](https://www.webcomponents.org/collection/PolymerElements/paper-elements), a whole set is greater than the sum of the individual parts. The catalog lets you publish your own collection of elements, organized however you see fit. Collections can also include other collections.
* [Gitter chat](https://gitter.im/webcomponents/community) for chatting with other web component developers.

All of the elements and element product lines currently built and maintained by the Polymer Project are [published on the new catalog](https://www.webcomponents.org/author/PolymerElements). We’re now considering the previous catalog site - [elements.polymer-project.org/](https://elements.polymer-project.org/) - deprecated in favor of webcomponents.org, and plan to eventually redirect all URL’s from elements.polymer-project.org to the new catalog.

The new catalog and site is a constant work in progress and community-driven, so please feel free to file issues, ideas, or PR’s to the [repository](https://github.com/webcomponents/webcomponents.org).

Happy componentizing!
