---
title:  "News Progressive Web App"

---

We're excited to release a new progressive web app demo and template built with Polymer - [Polymer News](https://news.polymer-project.org/list/top_stories)!

The Polymer News progressive web app is designed to showcase the fast performance and slick user experience possible using modern web platform features, and serve as a jumping-off point for building a more custom and feature-rich app.

It is built with Polymer 1.x (to be upgraded to [Polymer 2.0](https://www.polymer-project.org/2.0/docs/about_20) after 2.0 is released), and patterned after a typical "news" site - with categories and article pages.  It showcases a number of different application patterns:

* Built using the [Polymer CLI](https://www.polymer-project.org/1.0/docs/tools/polymer-cli).
* Uses a [Service Worker](https://www.polymer-project.org/1.0/toolbox/service-worker) generated by the CLI to help it work offline.
* Served via the [PRPL Pattern](https://www.polymer-project.org/1.0/toolbox/server#prpl-pattern) for hyper-efficient loading.
* Lazy-loads ads using the [Intersection Observer API](https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API)
* Designed to be able to directly integrate [AMP documents](https://www.ampproject.org/) as article content, using the new `<amp-viewer>` element.

Polymer News will join [Polymer Shop](https://shop.polymer-project.org) as a showcase and template for the [Polymer App Toolbox](https://www.polymer-project.org/1.0/toolbox/index). The App Toolbox provides various components that are useful in building high-quality PWA's, and the Shop and News demos show how they can be assembled into complete apps.

The Polymer News app in particular is designed to be easily extendable. In addition to the [Polymer News case study](/1.0/toolbox/news-case-study) in the App Toolbox docs, we've created a [standalone documentation site](https://news-docs.polymer-project.org) that explains how Polymer News works and how you can customize it.

And of course, for a deep dive into the code, check out the [Polymer News repository on Github](https://github.com/polymer/news).
