---
title:  "Welcome 2.0 Release Candidate!"

---

We're pleased to announce that we've cut a release candidate of Polymer 2.0! This release candidate is feature complete, and incorporates pre-release feedback from the community. We've fixed the major issues reported during the preview period and tested it across all supported browsers from Internet Explorer 11 to Safari Tech Preview.

The new library is more modular than before, starting at just 10kb for `Polymer.Element`, the base class to extend elements from. We’ve squeezed out even more performance increases on native browsers, like Safari Tech Preview and Chrome. Polymer 2.0 remains focused on bringing development closer to the platform than ever before, leveraging the power of the browser to build performant, large-scale applications.

Because of the number of complex applications relying on Polymer 1.x, backwards compatibility is a staple of this release. Our release candidate period will be focused on confirming that our Legacy APIs and compatibility layer provide support for manageable transitions. We will be relying on you, our users, to stress test our features. 

If you have a project you’d like to transition, we’ve developed an upgrade guide for you to reference. Please file any and all bugs you find as issues on GitHub, so we can look into the scenario. As with any open source project, community feedback is crucial to our success and we greatly appreciate your contributions.  

What's left for us to do, you might ask? 2.0-compatible hybrid elements are essentially done and ready for use, except for a few small issues mostly on IE11. As we run up to our general release we'll be working on these, as well as more bug fixes for the core library and performance tuning for the polyfills.

### Begin a project with 2.0

As for building fresh, new projects with Polymer 2.0, today is a great day to begin! 

If you want a taste of the new Polymer library, take a quick tour of the [2.0 APIs](https://www.polymer-project.org/2.0/docs/api/). You can also scan through the [About 2.0](https://www.polymer-project.org/2.0/docs/about_20) section and [Upgrade guide](https://www.polymer-project.org/2.0/docs/upgrade) on our site for more detailed information about the changes we’ve made. 

We’ve updated and refreshed the content on polymer-project.org, and you can easily switch between the Polymer 1.x and 2.x documentation. Because of the modular design of Polymer 2.x, we’ve added much more comprehensive documentation for the core APIs. We also have updated tutorials to help first-timers get started. 

Along with a library of updated documentation, we’ve added a new Community page where you can easily see all of the various ways to find support, and get your questions answered. 

### But wait, there's more...

In sync with the 2.0 Release Candidate, we're releasing a preview of our 2.0-ready tools. This cut includes many advances in the Polymer CLI, Dev Server (polyserve), Web Component Tester, and a new Linter and Bundler.

The build tool chain is all-new and based on the new Polymer Analyzer and Bundler (which replace Hydrolysis and Vulcanize, respectively). It's faster and more configurable to allow producing multiple builds with options for ES6 compilation, bundling, Service Worker generation and more. The development server and Web Component Tester also handle compiling on-the-fly, to make it easier to test with multiple browsers.

The 2.0-ready tools handle both Polymer 1.x and 2.x projects, and add support for testing and serving "variants" of project dependencies, to make it easy to build and test hybrid elements under Polymer 1.x and 2.x.

Also included are new Polymer 2.0 based templates, available in the `polymer init` command.

### We couldn’t have done it without you!
Making advancements and changes in the library while holding to our “minimally-breaking” goal was certainly a challenge. However, it was made much easier with the support, critical and constant feedback, and enthusiasm from the Polymer community. We particularly want to highlight the hard work and curiosity of our world-class Google Developer Experts, partners, and community members that tried our ever-evolving pre-release branch. Seeing the projects you shared on Twitter, and engaging in discussions with you on Slack about 2.0 trade-offs, kept us motivated to keep on chugging along. 

We’re extremely proud of what we’ve all been able to accomplish together, and look forward to seeing what you create with it next. 

<a href="https://www.polymer-project.org/2.0/start/" class="blue-button">GET STARTED</a>
<a href="https://www.polymer-project.org/2.0/docs/about_20" class="blue-button">ABOUT 2.0</a>
