---
title: Polymer at I/O ‘17, ICYMI
---

Last week, thousands of developers converged in Mountain View, CA for Google I/O 2017. While the Polymer Project has been featured at I/O for the past few years, 2017 was our largest presence yet. Our presence included three sessions from our team, two codelabs, tons of Office Hours, an After Hours installation, and an event-wide scavenger hunt.

## Sessions

**Future, faster: Unlock the Power of Web Components with Polymer**<br>
_with Kevin Schaaf, Taylor Savage, and Wendy Ginsberg_

[![Polymer Keynote IO talk](https://img.youtube.com/vi/cuoZenpQveQ/0.jpg)](https://www.youtube.com/watch?v=cuoZenpQveQ)

Hear all about the Polymer Project’s mission, dive into Polymer 2.0 and the goals behind its release, and take a tour through all of the other areas we’re working in.

**Polymer: Billions Served; Lessons Learned**<br>
_with Monica Dinculescu_

[![Monica's IO talk](https://img.youtube.com/vi/assSM3rlvZ8/0.jpg)](https://www.youtube.com/watch?v=assSM3rlvZ8)

What is the benefit of the modularized Polymer 2.0 library, and how does it all work? Monica takes you through each part, building one on top of the other, as we construct a Polymer element from a vanilla one.

**Developer Tooling for Web Components**<br>
_with Justin Fagnani-Bell_

[![Justin's IO talk](https://img.youtube.com/vi/tKvNeNGmOtU/0.jpg)](https://www.youtube.com/watch?v=tKvNeNGmOtU)

On the Polymer Project, we create Tools for all web components, not just those built with Polymer. Justin will show you how our tools empower you every step of the way as you build your app, from initialization all the way through deployment. Of course, you will be working with all of the best web practices including bundling, PRPL pattern rendering and loading, and more.

## Codelabs

#### PRPL with Custom Elements and Firebase

Learn how to implement the PRPL pattern using an app built on Custom Elements and Firebase hosting.<br>
<a href="https://codelabs.developers.google.com/codelabs/prpl-ce-firebase/index.html?index=..%2F..%2Fio2017#0">Get started.</a>

#### How to Contribute to the Web Components Ecosystem

Learn to build a web component with plain JavaScript, and how to publish it on WebComponents.org. </br>
<a href="https://codelabs.developers.google.com/codelabs/web-components-how-to-contribute/index.html?index=..%2F..%2Fio2017#0"> Get started. </a>

## Fun & Games

#### Cheese

While we build the App Toolbox to help developers build web component based progressive web apps more efficiently and simply, we also build reference apps and case studies. Our most recent Apps project came out of a challenge to our team: to build an awesome mobile experience that we would only expect from native, in a tiny fraction of the size. Out of that came Cheese, a photo editing app powered by Google’s Vision APIs which detects your facial features and expression, and smartly decorates your photo with silly emoji combinations. Try it out at <a href="https://cheese.polymer-project.org">cheese.polymer-project.org</a> and share your best photos with [@polymer](https://twitter.com/polymer).

#### Polymon Global Scavenger Hunt

All around the I/O grounds, Physical Web beacons and QR code posters were hidden, so attendees could search and find Polymon, virtual magical creatures. They could use their collection to assemble a team and battle their friends! Codes were released on social media, and QR code posters were present at I/O extended events around the world, so everyone was able to participate. The I/O version of Polymon can be found at <a href="https://polymon.polymer-project.org">polymon.polymer-project.org</a>.

#### After Hours Polymon Battle Stage

On the first night of I/O, the After Hours Arcade was turned into a Polymon Battle Stage! Attendees lined up to sit in the Battle Pods and challenge others on the big screen. The game was developed and advanced to handle this live spectator experience!


<a class="blue-button" href="/2.0/docs/about_20">More on Polymer 2.0</a>