---
title: "Polymer Summit 2017 Speaker Spotlight: Bede Overend, Simpla"
---

Bede Overend of Simpla talks engagement on the Web, and how Polymer speeds up the process of developing with Web Components.

**Could you tell us a bit about your favorite project you built with Polymer?**

It’d have to be Simpla, a project I’ve been working on for a couple of years now. It’s a library of web components that people can install and use to display and edit content, like a modular content management system.

**What was it about Polymer that made it a good fit for Simpla?**

For what we’re doing, we needed to give our consumers a clean editing UI that didn’t interfere with their DOM projects. This is key for us. We wanted to provide a library that they didn’t have to worry about and could feel safe using with any other library or framework - essentially just easy interoperability. That’s a pretty fundamental driver behind Custom Elements and Shadow DOM, so going with Web Components in general was an easy choice.

**What was positive about the development process with Polymer?**

I think the biggest part has been the community, but also certainly the developer experience of creating elements.

We started with Polymer back in 2015, so it was still pretty early days. But having the Polymer community to help, and the current library of elements which we could build off was a huge help in kickstarting the process.

**Could you elaborate a bit on the developer experience of creating elements? What makes it work for you?**

[It simplifies] setting up a lot of the basic functionality you’d expect out of components. Things like setting up automatic data binding. Without Polymer this’d be a real nightmare. Another thing that you certainly don’t think of straight off the bat is, how should my attributes and properties communicate with one another? That surprisingly involves a lot without Polymer in place.

Also, I’d say Polymer gives a really nice and easy way to take your component model and map it into code. E.g. [how best to] codify the properties and methods you have in Custom Elements. Polymer helps out a *lot*.

**What’s an example of working in the Web Components community that delights you?**

The thing that still got me hooked initially, and still gets me so excited with Web Components: I can search for a component, import it, and no matter what system I’m using, I have UI and logic and it’s given to me via HTML. It is guaranteed to work with whatever tools or environment I already have set up.

With the frontend aspect of our service--the components, the javascript libraries--we want input and collaboration. We want feedback on these, and we want to (eventually) have people building their own elements. We try to keep this process as open as possible so that people can create their own components that can talk to our service, if they want. Then encouraging them to share it on places like WebComponents.org so that others can use it.

We can keep trying to make elements that will fit everyone’s needs, but a much better system is laying the foundations on on a technology like Web Components, and giving others the tools to help build out these elements themselves, where ours don’t fit their specific needs.

**What excites you most about Progressive Web Apps right now?**

Freedom I think - apps, as we currently see them on mobile devices, are funnelled through a closed system. The beauty of the web is the ability to so easily find what you need, and the idea of PWAs bringing the engagement of native apps with the freedom of the web is pretty exciting.

Installing the app itself doesn’t bother me a huge amount. But that’s also because I live in a wealthy nation with a decent phone and I don’t have to worry about the cost of Internet access or how long it’ll take to get going on my phone. Certainly the size of apps would be an issue if I wasn’t in that position. Also the “commitment” of installing a native app - this is more of an engagement issue. I’m less likely to try it out if I’ve got to go through the install or purchase process as opposed to just visiting a website and being ready to go.

The bigger thing for me though is that discoverability and accessibility as mentioned above.

**How would you make the Web better?**

Oof, tough question.

Given it is so big, I might go at it from a pretty specific angle.

I’m very interested in and invested in Web Components. As a developer, I’m also interested in developer experience.

What I would love to see is improving the developer experience around Web Components. For me there are a couple of drawbacks that need to be addressed at the spec level, and they’re in the works I think. But I want to see Web Components reach a level of developer experience that means users of any framework feel much more comfortable in utilizing them. More to the point though, this would hopefully lead to more developers using Web Components as a way to package up whatever functionality they’re developing. If we can do this, I think we’ll then see more people who are just starting out on the Web being able to utilize so much more functionality just in HTML by using these components others have developed, without necessarily having to have learnt a specific framework.

I think that would certainly have a flow on effect that has more people working on richer projects and therefore better experiences on the Web in general.

**What is your favorite food… and what are you looking forward to in your trip to Copenhagen?**

Oh man, these are quite possibly the hardest questions… Currently, I’d have to say my favourite food is Ramen. So good, right? As for Copenhagen, I think just wandering the streets and seeing old architecture. I haven’t spent much time in Europe, so every time I go I’m in awe of the beauty of the old buildings and cobblestone streets.

I’m also obviously super excited to meet and chat with some very interesting people :)

-----

Watch Bede's Polymer Summit talk here:

<google-youtube video-id="c-WDHG6rrdU"
          list-type="playlist"
          list="PLNYkxOF6rcIDP0PqVaJxqNWwIgvoEPzJi"
          autoplay="0"
          rel="0">
          </google-youtube>

This year's summit took place August 22–23 in beautiful downtown [Copenhagen, Denmark](https://goo.gl/maps/pgFPsEkRRcS2).

If you missed it, you can catch up on all the talks on [the Polymer Summit 2017 website](https://summit.polymer-project.org/).

Follow us on Twitter [@polymer](https://twitter.com/polymer) for regular updates.


