---
title:  "Polymer 2.4: Paving the way for 3.0 and TypeScript support"
---

Today we released Polymer 2.4. This is an incremental release that adds a few new features for use today, and others in preparation for the upcoming 3.0 release.  Many of these changes were already released to the `3.0-pre.6` preview on npm last week, and today's release makes these changes available as an official release via Bower for 2.x users.  

As a reminder, the ES module-based Polymer 3.0 source on npm is 100% generated from the Polymer 2.x HTML source using the [modulizer](https://github.com/Polymer/polymer-modulizer) migration tool, so all changes to 3.0 are being made either via changes to the 2.x source or the modulizer conversion tool itself.

## TypeScript support

The first new feature is official support for TypeScript types.  To date, the Polymer codebase has maintained the source of truth for types via [Closure Compiler types](https://github.com/google/closure-compiler/wiki/Annotating-JavaScript-for-the-Closure-Compiler) in jsdoc format. With TypeScript enjoying enthusiastic adoption in the open-source community, starting from v2.4 Polymer will ship with official type declarations for TypeScript. You’ll find them in the `types/` directory. There’s one `d.ts` file for each HTML import. These declarations are automatically generated from the Polymer source, so they’ll be kept up to date with every change. See [`gen-typescript-declarations`](https://github.com/Polymer/gen-typescript-declarations) for details on how this works. You can use this tool to generate typings for your own elements, too!

To use TypeScript, simply add references to the types for the library imports that you use from the `types` folder.  Below is a typical example of TypeScript usage in 2.4:

`my-element.html`
```html
<link rel="import" href="bower_components/polymer/polymer-element.html">
<dom-module id="my-element"><template>...</template></dom-module>
<script src="my-element.js">
```

`my-element.ts`
```ts
  /// <reference path="./bower_components/polymer/types/polymer-element.d.ts" />`
  class MyElement extends Polymer.Element {
    ...
  }
```

We’re also introducing [`polymer-decorators`](https://github.com/Polymer/polymer-decorators), an officially supported set of decorators to help you write Polymer elements with TypeScript in a type-safe, convenient way. This helps TypeScript understand the shape of your elements, giving you code completion and type checking on element properties.

In the coming months, expect to see additional support for TypeScript, including typings for Polymer 3.0, typings for the elements in the Polymer catalog, and support for analyzing TypeScript projects so that they can be used with `<iron-doc-viewer>` and other tools.

## `PropertiesMixin`

In Polymer 2.4 we have broken out a key subset of Polymer’s lower-level properties functionality into a tiny new mixin called `PropertiesMixin`. This mixin implements Polymer’s features for defining declarative properties, creating property accessors, and syncing properties with attributes. It provides a single `_propertiesChanged` callback and can be used to create new, lightweight base classes.

To illustrate, the following example shows a very simple element using `PropertiesMixin`:

```html
<link rel="import" href="bower_components/polymer/lib/mixins/properties-mixin.html">

<script>
  class MyPropertiesElement extends Polymer.PropertiesMixin(HTMLElement) {
    // Define properties to watch. You may only specify the property’s name and type.
    static get properties() {
      return {
        name: String
      }
    }
    // Called whenever the declared properties change.
    _propertiesChanged(currentProps, changedProps, oldProps) {
      // Render the changed content.
      this.textContent = `Hello, ${this.name}`;
    }
  }
</script>
```

This is an intentionally simple example; we don't expect many people to use `PropertiesMixin` directly. It's intended to provide support for new base classes.  For more information, see the source for `PropertiesMixin`.

## `Polymer.html` tag function

Starting with the 3.0 release, you need to return an instance of `HTMLTemplateElement` from your element’s static template getter—the option to return a string has been deprecated. This change makes the template type predictable, which in turn will make it simpler to extend superclass templates.

In Polymer 2.4+, returning a string from a static template getter will still work, but will generate a console warning.

If–like most Polymer developers–you are using `<dom-module>` to define your templates in HTML, **you don't need to make any changes**.  Your templates will continue to work in 2.4 (and any subsequent 2.x releases) as they always have, and Polymer Modulizer will automatically convert your templates when you update to Polymer 3.0.

Polymer 3.0 provides an `html` tag function that produces an `HTMLTemplateElement` from a template literal string. This function is available in 2.4 as `Polymer.html` if you're interested in playing with it:

```html
<link rel="import" href="bower_components/polymer/lib/polymer-element.html">

<script>
  class MyAppElement extends Polymer.Element {
    static get template() {
      return Polymer.html`<div>I'm a template</div>
                          <div>[[withBindings]]</div>
                          <button on-click="clickHandler">Click me!</button>`
    }
    ...
  }
  customElements.define('my-app-element', MyAppElement);
</script>
```

## One more thing: another Polymer 3.0 preview release

In addition to Polymer 2.4, we’ve also released another preview version of Polymer 3.0 this week.

The new versions of Polymer and the elements are available as version `3.0-pre.6` from npm (the `@next` version tag has also been updated to point to the new preview). In our latest release, we’ve fixed some bugs and made more progress with the conversion of all Polymer elements to Polymer 3.0.

See the [Polymer 3.0 Roadmap](https://github.com/Polymer/project/blob/master/Roadmap.md) for the details of what we’re working on, and visit the [element status page](https://github.com/Polymer/polymer-modulizer/blob/master/docs/polymer-3-element-status.md) to see which Polymer 3.0 elements are passing automated tests. Thanks for trying Polymer 3.0. We look forward to bringing you another preview release in two weeks!
