class DataView64 {
  constructor(arrayBuffer) {
    this._dataView = new DataView(arrayBuffer);
  }

  get buffer() {
    return this._dataView.buffer;
  }

  getUint64(offset, littleEndian) {
    var left = this.getUint32(offset, littleEndian);
    var right = this.getUint32(offset + 4, littleEndian);
    if (littleEndian) {
      return left << 32 | right;
    }
    return right << 32 | left;
  }

  getInt64(offset, littleEndian) {
    var left, right;
    if (littleEndian) {
      left = this.getInt32(offset, littleEndian);
      right = this.getUint32(offset + 4, littleEndian);

      return left << 32 | right;
    }
    left = this.getUint32(offset, littleEndian);
    right = this.getInt32(offset + 4, littleEndian);
    return right << 32 | left;
  }

  getUint8(offset, littleEndian) {
    return this._dataView.getUint8(offset, littleEndian);
  }

  getInt8(offset, littleEndian) {
    return this._dataView.getInt8(offset, littleEndian);
  }

  getUint16(offset, littleEndian) {
    return this._dataView.getUint16(offset, littleEndian);
  }

  getInt16(offset, littleEndian) {
    return this._dataView.getInt16(offset, littleEndian);
  }

  getUint32(offset, littleEndian) {
    return this._dataView.getUint32(offset, littleEndian);
  }

  getInt32(offset, littleEndian) {
    return this._dataView.getInt32(offset, littleEndian);
  }

  getFloat32(offset, littleEndian) {
    return this._dataView.getFloat32(offset, littleEndian);
  }

  getFloat64(offset, littleEndian) {
    return this._dataView.getFloat64(offset, littleEndian);
  }
}

module.exports = DataView64;
