'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Autocomplete = require('../src/Autocomplete');

var SCOPE = { React: React, Autocomplete: Autocomplete };

var EXAMPLE_IMPORT = 'const Autocomplete = require(\'gitbook-styleguide/lib/Autocomplete\');';

var EXAMPLE_DEFAULT = '<Autocomplete\n    placeholder="Enter a language"\n    onFetch={(query, callback) => {\n        callback([\n            { id: \'en\', label: \'English\' },\n            { id: \'fr\', label: \'French\' }\n        ])\n    }}\n    onChange={(query, result) => alert(\'Selected is \' + result.label)}\n    renderResult={({result}) => <span><b>{result.id}</b> {result.label}</span>}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Autocomplete', active: 'autocomplete' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Autocomplete' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};