'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var FilterList = require('../src/FilterList');
var Icon = require('../src/Icon');
var ListGroup = require('../src/ListGroup');
var Overview = require('../src/Overview');
var Pagination = require('../src/Pagination');
var PageHead = require('../src/PageHead');
var Menu = require('../src/Menu');
var SearchBar = require('../src/SearchBar');
var Row = require('../src/Row');
var Container = require('../src/Container');

var SCOPE = { React: React, FilterList: FilterList, Panel: Panel, ListGroup: ListGroup, Icon: Icon, Overview: Overview,
    Pagination: Pagination, PageHead: PageHead, Menu: Menu, SearchBar: SearchBar, Row: Row, Container: Container };

var EXAMPLE_IMPORTS = 'const FilterList = require(\'gitbook-styleguide/lib/FilterList\');\nconst Menu = require(\'gitbook-styleguide/lib/Menu\');\nconst SearchBar = require(\'gitbook-styleguide/lib/SearchBar\');\nconst PageHead = require(\'gitbook-styleguide/lib/PageHead\');\nconst Pagination = require(\'gitbook-styleguide/lib/Pagination\');\nconst ListGroup = require(\'gitbook-styleguide/lib/ListGroup\');\nconst Overview = require(\'gitbook-styleguide/lib/Overview\');';

var EXAMPLE_MENU = '<Panel>\n    <ListGroup>\n        <ListGroup.Item active={true}>\n            <Icon id="gear" size="sm" /> Account\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="person" size="sm" /> Profile\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="mail" size="sm" /> Notifications\n        </ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_PAGEHEAD_MENU = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={5}>\n                <PageHead.Title>\n                    Contact GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={7}>\n                <Menu right>\n                    <Menu.Item>About</Menu.Item>\n                    <Menu.Item active>Contact</Menu.Item>\n                    <Menu.Item>Terms of Service</Menu.Item>\n                </Menu>\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_OVERVIEW = '<PageHead>\n    <Container>\n        <Overview>\n            <Overview.Title>\n                <Overview.StepTitle href="/">\n                    myorg\n                </Overview.StepTitle>\n                <Overview.StepDivider />\n                <Overview.StepTitle primary>\n                    My Book\n                </Overview.StepTitle>\n            </Overview.Title>\n            <Overview.Note>\n                Updated 2 days ago\n            </Overview.Note>\n        </Overview>\n    </Container>\n    <Container>\n        <Menu left>\n            <Menu.Item>Overview</Menu.Item>\n            <Menu.Item active>Metrics</Menu.Item>\n            <Menu.Item>Settings</Menu.Item>\n        </Menu>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_SEARCH = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={8}>\n                <PageHead.Title>\n                    <Icon id="star" size="sm" /> Explore GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={4}>\n                <SearchBar placeholder="Search books" />\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_FILTERLIST = '<FilterList>\n    <FilterList.Item selected={true} count={21}>First filter</FilterList.Item>\n    <FilterList.Item count={3}>Second filter</FilterList.Item>\n    <FilterList.Item>Third filter</FilterList.Item>\n</FilterList>';

var EXAMPLE_PAGINATION = '<Pagination page={4} pages={20} />';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Navigation', active: 'navigation' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Navigation' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'This styleguide comes with several navigation components. Some were designed with singular purposes, while others were design to be more flexible and appear quite frequently.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORTS })
            )
        ),
        React.createElement(Example, { title: 'Page head with menu', source: EXAMPLE_PAGEHEAD_MENU, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with search bar', source: EXAMPLE_PAGEHEAD_SEARCH, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with overview', source: EXAMPLE_PAGEHEAD_OVERVIEW, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Menu', source: EXAMPLE_MENU, scope: SCOPE },
            'The menu is a vertical list of navigational links. It should be put in a panel.'
        ),
        React.createElement(
            Example,
            { title: 'Filter list', source: EXAMPLE_FILTERLIST, scope: SCOPE },
            'A vertical list of filters. Grey text on white background. Selecting a filter from the list will fill its background with blue and make the text white.'
        ),
        React.createElement(Example, { title: 'Pagination', source: EXAMPLE_PAGINATION, scope: SCOPE })
    );
};