'use strict';

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');
var Menu = require('./Menu');
var Logo = require('../icons/Logo');

/**
 * Logo of GitBook in the footer
 * @type {ReactClass}
 */
var FooterLogo = React.createClass({
    displayName: 'FooterLogo',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'footer-logo' },
            React.createElement(Logo, null)
        );
    }
});

/**
 * Copyright in the footer
 * @type {ReactClass}
 */
var FooterCopyright = React.createClass({
    displayName: 'FooterCopyright',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            Menu.Item,
            { href: 'https://www.gitbook.com', className: 'footer-copyright' },
            '\xA9 GitBook.com'
        );
    }
});

/**
 * Container for the footer.
 * @type {ReactClass}
 */
var PageFooter = React.createClass({
    displayName: 'PageFooter',

    statics: {
        Copyright: FooterCopyright,
        Logo: FooterLogo
    },

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-page-footer' },
            this.props.children
        );
    }
});

module.exports = PageFooter;