'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'text-link', 'text-danger', 'text-success', 'text-warning', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        var clicked = this.state.clicked;


        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.onClick = this.onClick;

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block;


        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'btn-toolbar ' + (this.props.className || '') },
            this.props.children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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