'use strict';

var React = require('react');
var classNames = require('classnames');

var Pagination = React.createClass({
    displayName: 'Pagination',

    propTypes: {
        // Index of current page
        page: React.PropTypes.number.isRequired,

        // Total count of pages
        pages: React.PropTypes.number.isRequired,

        // Minimum number of pages to list
        pagesToList: React.PropTypes.number,

        // Callback when page changed (optional)
        onChange: React.PropTypes.func,

        // Current uri
        getURL: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            getURL: function getURL(page) {
                return '?page=' + page;
            },
            pagesToList: 5
        };
    },


    /**
     * Clicked to select a page
     * @param  {Number} i
     */
    onSelectPage: function onSelectPage(i, e) {
        if (this.props.onChange) {
            e.preventDefault();
            return this.props.onChange(i);
        }
    },


    /**
     * Render a page selector
     * @param {Number} i
     * @param {String} text
     * @return {React.Element}
     */
    renderPageItem: function renderPageItem(i, text) {
        var page = this.props.page;
        var isActive = i === page;
        var className = classNames({
            active: isActive
        });
        var uri = this.props.getURL(i);

        return React.createElement(
            'li',
            { key: i, className: className },
            React.createElement(
                'a',
                { href: uri, onClick: this.onSelectPage.bind(this, i) },
                text || i + 1
            )
        );
    },
    render: function render() {
        var page = this.props.page;
        var pages = this.props.pages;
        var pagesToList = this.props.pagesToList;

        if (pages < 2) {
            return React.createElement('div', null);
        }

        if (page < 0) page = 0;
        if (page >= pages) page = pages - 1;

        var startRange = Math.max(0, page - pagesToList);
        var maxRange = pages;
        var endRange = Math.min(maxRange, page + pagesToList);
        var pagesRange = Array.from(Array(pages)).map(Number.call, Number).slice(startRange, endRange);

        return React.createElement(
            'div',
            { className: 'pagination' },
            React.createElement(
                'ul',
                { className: 'pagination-pages' },
                startRange === 0 ? '' : this.renderPageItem(0),
                startRange === 0 ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                pagesRange.map(function (i) {
                    return this.renderPageItem(i);
                }, this),
                endRange === maxRange ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                endRange === maxRange ? '' : this.renderPageItem(maxRange)
            ),
            React.createElement(
                'ul',
                { className: 'pagination-nav' },
                page < 1 ? '' : this.renderPageItem(page - 1, '« previous page'),
                page >= maxRange - 1 ? '' : this.renderPageItem(page + 1, 'next page »')
            )
        );
    }
});

module.exports = Pagination;
//# sourceMappingURL=data:application/json;base64,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