'use strict';

var React = require('react');

var HTMLPage = React.createClass({
    displayName: 'HTMLPage',

    getDefaultProps: function getDefaultProps() {
        return {
            lang: 'en'
        };
    },

    render: function render() {
        return React.createElement(
            'html',
            { lang: this.props.lang },
            this.props.children
        );
    }
});

var HTMLHead = React.createClass({
    displayName: 'HTMLHead',

    getDefaultProps: function getDefaultProps() {
        return {
            charset: 'utf-8'
        };
    },

    render: function render() {
        return React.createElement(
            'head',
            null,
            React.createElement('meta', { charset: this.props.charset }),
            this.props.children
        );
    }
});

var HTMLBody = React.createClass({
    displayName: 'HTMLBody',

    render: function render() {
        return React.createElement(
            'body',
            null,
            this.props.children
        );
    }
});

module.exports = HTMLPage;
module.exports.Head = HTMLHead;
module.exports.Body = HTMLBody;