'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        var clicked = this.state.clicked;


        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;
        props.onClick = this.onClick;

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block;


        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'btn-toolbar ' + (this.props.className || '') },
            this.props.children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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