'use strict';

var React = require('react');
var Menu = require('./Menu');
var Logo = require('../icons/Logo');

/**
 * Logo of GitBook in the footer
 * @type {ReactClass}
 */
var FooterLogo = React.createClass({
    displayName: 'FooterLogo',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'footer-logo' },
            React.createElement(Logo, null)
        );
    }
});

/**
 * Copyright in the footer
 * @type {ReactClass}
 */
var FooterCopyright = React.createClass({
    displayName: 'FooterCopyright',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            Menu.Item,
            { href: 'https://www.gitbook.com', className: 'footer-copyright' },
            '\xA9 GitBook.com'
        );
    }
});

/**
 * Container for the footer.
 * @type {ReactClass}
 */
var PageFooter = React.createClass({
    displayName: 'PageFooter',

    statics: {
        Copyright: FooterCopyright,
        Logo: FooterLogo
    },

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-page-footer' },
            this.props.children
        );
    }
});

module.exports = PageFooter;
//# sourceMappingURL=data:application/json;base64,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