'use strict';

var _head = require('next/head');

var _head2 = _interopRequireDefault(_head);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('react');

var _require = require('react-sticky'),
    StickyContainer = _require.StickyContainer,
    Sticky = _require.Sticky;

var PageWrapper = require('../../src/PageWrapper');
var PageInner = require('../../src/PageInner');
var PageBody = require('../../src/PageBody');
var Container = require('../../src/Container');
var Panel = require('../../src/Panel');
var Row = require('../../src/Row');
var ListGroup = require('../../src/ListGroup');

var Footer = require('./Footer');
var Header = require('./Header');

var Menu = function Menu(_ref) {
    var active = _ref.active;
    return React.createElement(
        ListGroup,
        null,
        React.createElement(
            ListGroup.Item,
            { active: active == 'introduction', href: '/' },
            'Introduction'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'icons', href: '/icons' },
            'Logos and Icons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'buttons', href: '/buttons' },
            'Buttons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'links', href: '/links' },
            'Links'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'forms', href: '/forms' },
            'Forms and Inputs'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'navigation', href: '/navigation' },
            'Navigation'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'alerts', href: '/alerts' },
            'Alerts'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'blankslates', href: '/blankslates' },
            'Blankslates'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'modals', href: '/modals' },
            'Modals'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'tooltips', href: '/tooltips' },
            'Tooltips'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'panels', href: '/panels' },
            'Panels'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'dropdowns', href: '/dropdowns' },
            'Dropdowns'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'popovers', href: '/popovers' },
            'Popovers'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'autocomplete', href: '/autocomplete' },
            'Autocomplete'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'cards', href: '/cards' },
            'Cards'
        )
    );
};
Menu.propTypes = {
    active: React.PropTypes.bool
};

var Page = React.createClass({
    displayName: 'Page',

    propTypes: {
        title: React.PropTypes.string,
        active: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            active = _props.active;


        return React.createElement(
            PageWrapper,
            null,
            React.createElement(
                _head2.default,
                null,
                React.createElement(
                    'title',
                    null,
                    title
                ),
                React.createElement('link', { rel: 'stylesheet', href: '/static/css/gitbook.css' }),
                React.createElement('link', { rel: 'stylesheet', href: '/static/images/logo/favicon.ico' }),
                React.createElement('link', { rel: 'stylesheet', href: 'https://cdnjs.cloudflare.com/ajax/libs/prism/1.5.1/themes/prism.css' }),
                React.createElement('meta', { charSet: 'UTF-8' }),
                React.createElement('meta', { name: 'viewport', content: 'initial-scale=1.0, width=device-width' })
            ),
            React.createElement(Header, null),
            React.createElement(
                PageBody,
                null,
                React.createElement(
                    PageInner,
                    null,
                    React.createElement(
                        StickyContainer,
                        null,
                        React.createElement(
                            Container,
                            null,
                            React.createElement(
                                Row,
                                null,
                                React.createElement(
                                    Row.Col,
                                    { md: 3 },
                                    React.createElement(
                                        Sticky,
                                        { stickyStyle: { marginTop: 20 } },
                                        React.createElement(
                                            Panel,
                                            null,
                                            React.createElement(Menu, { active: active })
                                        )
                                    )
                                ),
                                React.createElement(
                                    Row.Col,
                                    { md: 9 },
                                    children
                                )
                            )
                        )
                    )
                )
            ),
            React.createElement(Footer, null)
        );
    }
});

module.exports = Page;
//# sourceMappingURL=data:application/json;base64,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