'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Page = require('./components/Page');
var Panel = require('../src/Panel');
var CodeEditor = require('./components/CodeEditor');

exports.default = function () {
    return _react2.default.createElement(
        Page,
        { title: 'About', active: 'introduction' },
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'About this styleguide' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'GitBook Styleguide is a collection of styling, React components and rules;',
                    ' ',
                    'which are being used by the GitBook team on our applications such as gitbook.com.'
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'This styleguide is open to criticsms and feedback, feel free to ',
                    _react2.default.createElement(
                        'a',
                        { href: 'https://github.com/GitbookIO/styleguide' },
                        'post an issue on GitHub'
                    ),
                    '.'
                )
            )
        ),
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'Installation' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'GitBook styleguide can be installed using ',
                    _react2.default.createElement(
                        'b',
                        null,
                        'NPM'
                    ),
                    ',',
                    ' ',
                    'the module is published as ',
                    _react2.default.createElement(
                        'code',
                        null,
                        'gitbook-styleguide'
                    ),
                    '.'
                ),
                _react2.default.createElement(CodeEditor, { source: '$ npm install gitbook-styleguide --save-dev' })
            )
        ),
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'Open Source' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'Available for use under the ',
                    _react2.default.createElement(
                        'b',
                        null,
                        'Apache 2.0'
                    ),
                    ' license and built with open source projects like React, LESS and more.'
                )
            )
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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