'use strict';

var React = require('react');
var classNames = require('classnames');

var STYLES = require('./STYLES');

var Panel = React.createClass({
    displayName: 'Panel',

    propTypes: {
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            style: STYLES[0]
        };
    },
    render: function render() {
        var style = this.props.style;

        return React.createElement(
            'div',
            { className: classNames('panel', 'panel-' + style) },
            this.props.children
        );
    }
});

var PanelHeading = React.createClass({
    displayName: 'PanelHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var title = this.props.title;
        var inner = '';

        if (title) {
            inner = React.createElement(
                PanelTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'panel-heading' },
            inner,
            this.props.children
        );
    }
});

var PanelTitle = React.createClass({
    displayName: 'PanelTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h3',
            { className: 'panel-title' },
            this.props.children
        );
    }
});

var PanelToolbar = React.createClass({
    displayName: 'PanelToolbar',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-toolbar' },
            this.props.children
        );
    }
});

var PanelBody = React.createClass({
    displayName: 'PanelBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-body' },
            this.props.children
        );
    }
});

module.exports = Panel;
module.exports.Heading = PanelHeading;
module.exports.Title = PanelTitle;
module.exports.Body = PanelBody;
module.exports.Toolbar = PanelToolbar;
//# sourceMappingURL=data:application/json;base64,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