'use strict';

var React = require('react');
var classNames = require('classnames');

/**
 * <Tabs>
 *   <Tabs.Nav>
 *     <Tabs.Item active>Hello</Tabs.Item>
 *     <Tabs.Item>World</Tabs.Item>
 *   </Tabs.Nav>
 *   <Tabs.Content>
 *
 *   </Tabs.Content>
 * </Tabs>
 */

var Tabs = React.createClass({
    displayName: 'Tabs',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'tabs' },
            this.props.children
        );
    }
});

var TabsNav = React.createClass({
    displayName: 'TabsNav',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'tabs-nav' },
            this.props.children
        );
    }
});

var TabsItem = React.createClass({
    displayName: 'TabsItem',

    propTypes: {
        children: React.PropTypes.node,
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#'
        };
    },
    onClick: function onClick(event) {
        var onClick = this.props.onClick;


        if (onClick) {
            event.preventDefault();
            onClick();
        }
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            href = _props.href,
            active = _props.active;


        return React.createElement(
            'li',
            { className: classNames({ active: active }) },
            React.createElement(
                'a',
                { href: href, onClick: this.onClick },
                children
            )
        );
    }
});

var TabsContent = React.createClass({
    displayName: 'TabsContent',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'tabs-content' },
            this.props.children
        );
    }
});

module.exports = Tabs;
module.exports.Nav = TabsNav;
module.exports.Item = TabsItem;
module.exports.Content = TabsContent;
//# sourceMappingURL=data:application/json;base64,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